/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.web.context;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.johnson.spring.web.SpringEventType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Conventions;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class JohnsonContextLoaderListener
extends ContextLoaderListener {
    public static final String ATTR_BYPASSED = Conventions.getQualifiedAttributeName(JohnsonContextLoaderListener.class, (String)"bypassed");
    private static final Logger LOG = LoggerFactory.getLogger(JohnsonContextLoaderListener.class);

    public JohnsonContextLoaderListener() {
    }

    public JohnsonContextLoaderListener(WebApplicationContext context) {
        super(context);
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            super.contextDestroyed(event);
        }
        finally {
            event.getServletContext().removeAttribute(ATTR_BYPASSED);
        }
    }

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) {
        String eventType = SpringEventType.getContextEventType(servletContext);
        JohnsonEventContainer container = Johnson.getEventContainer((ServletContext)servletContext);
        if (container.hasEvents()) {
            LOG.debug("Searching Johnson for previous {} errors", (Object)"fatal");
            for (Event event : container.getEvents()) {
                EventLevel level = event.getLevel();
                if (!"fatal".equals(level.getLevel())) continue;
                LOG.error("Bypassing Spring ApplicationContext initialisation; a previous {} error was found: {}", (Object)level.getLevel(), (Object)event.getDesc());
                servletContext.setAttribute(ATTR_BYPASSED, (Object)Boolean.TRUE);
                if (SpringEventType.addEventOnBypass(servletContext)) {
                    String message = "The Spring WebApplicationContext will not be started due to a previous " + level.getLevel() + " error";
                    container.addEvent(new Event(EventType.get((String)eventType), message, level));
                }
                return null;
            }
        }
        WebApplicationContext context = null;
        try {
            LOG.debug("Attempting to initialise the Spring ApplicationContext");
            context = super.initWebApplicationContext(servletContext);
        }
        catch (Throwable t) {
            String message = "The Spring WebApplicationContext could not be started";
            LOG.error(message, t);
            servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            Event event = SpringEventType.translateThrowable(servletContext, t);
            if (event == null && (event = this.createEvent(eventType, message, t)) == null) {
                event = SpringEventType.createDefaultEvent(eventType, message, t);
            }
            servletContext.setAttribute(ATTR_BYPASSED, (Object)event);
            container.addEvent(event);
        }
        return context;
    }

    @Nonnull
    protected Event createEvent(@Nonnull String defaultEventType, @Nonnull String defaultMessage, @Nonnull Throwable t) {
        return SpringEventType.createDefaultEvent(defaultEventType, defaultMessage, t);
    }
}

