/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.web.context.support;

import com.atlassian.johnson.context.JohnsonContextListener;
import com.atlassian.johnson.spring.web.context.JohnsonContextLoaderListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.EventListener;
import org.springframework.web.context.AbstractContextLoaderInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractJohnsonContextLoaderInitializer
extends AbstractContextLoaderInitializer {
    protected ContextLoaderListener createContextLoaderListener(WebApplicationContext context) {
        return new JohnsonContextLoaderListener(context);
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        this.registerJohnsonContextListener(servletContext);
        super.onStartup(servletContext);
    }

    protected void registerContextLoaderListener(ServletContext servletContext) {
        WebApplicationContext context = this.createRootApplicationContext();
        if (context == null) {
            this.logger.debug((Object)"No ContextLoaderListener registered, as createRootApplicationContext() did not return an application context");
        } else {
            servletContext.addListener((EventListener)this.createContextLoaderListener(context));
        }
    }

    protected void registerJohnsonContextListener(ServletContext servletContext) {
        JohnsonContextListener.register((ServletContext)servletContext);
    }
}

