/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class BypassableDelegatingFilterProxy
extends DelegatingFilterProxy {
    private static final Logger LOG = LoggerFactory.getLogger(BypassableDelegatingFilterProxy.class);
    private volatile boolean bypassable = true;

    public void doFilter(@Nonnull ServletRequest request, @Nonnull ServletResponse response, @Nonnull FilterChain filterChain) throws ServletException, IOException {
        if (this.bypassable && this.findWebApplicationContext() == null) {
            LOG.warn("Bypassing [{}]; no Spring WebApplicationContext is available", (Object)this.getFilterName());
            filterChain.doFilter(request, response);
        } else {
            LOG.trace("Found Spring WebApplicationContext; attempting to invoke delegate");
            super.doFilter(request, response, filterChain);
        }
    }

    protected Filter initDelegate(WebApplicationContext wac) throws ServletException {
        LOG.debug("Filter [{}] is no longer bypassable; the WebApplicationContext is available", (Object)this.getFilterName());
        this.bypassable = false;
        return super.initDelegate(wac);
    }
}

