/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.contributing;

import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.server.internal.contributing.ContributingGuidelinesService;
import com.atlassian.bitbucket.server.internal.contributing.PatternMatchingContentTreeCallback;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultContributingGuidelinesService
implements ContributingGuidelinesService {
    private static final String CONTRIBUTING_FILE_PATTERN = "CONTRIBUTING(\\.(md|markdown|mdown|mkdn|mkd|text|txt))?";
    private static final Pattern CONTRIBUTING_FILE_MATCHER = Pattern.compile("CONTRIBUTING(\\.(md|markdown|mdown|mkdn|mkd|text|txt))?", 2);
    private static final int PAGE_LIMIT = 500;
    private static final Logger log = LoggerFactory.getLogger(DefaultContributingGuidelinesService.class);
    private final ContentService contentService;
    private final PermissionValidationService permissionValidationService;
    private final RefService refService;
    private final Cache<String, Optional<Path>> settingsCache;

    @Autowired
    public DefaultContributingGuidelinesService(ContentService contentService, CacheFactory cacheFactory, PermissionValidationService permissionValidationService, RefService refService) {
        this.contentService = contentService;
        this.permissionValidationService = permissionValidationService;
        this.refService = refService;
        this.settingsCache = cacheFactory.getCache("com.atlassian.bitbucket.server.internal.contributing.ContributingGuidelinesService.settingsCache", null, new CacheSettingsBuilder().remote().replicateAsynchronously().expireAfterWrite(6L, TimeUnit.HOURS).replicateViaInvalidation().build());
    }

    @Override
    @Nonnull
    public Optional<Path> getPath(@Nonnull Repository repository, String at) {
        Objects.requireNonNull(repository, "repository");
        this.permissionValidationService.validateRepositoryAccessible(repository);
        if (StringUtils.isBlank((CharSequence)at)) {
            try {
                at = this.refService.getDefaultBranch(repository).getId();
            }
            catch (NoDefaultBranchException | RepositoryOfflineException e) {
                return Optional.empty();
            }
        }
        String cacheKey = repository.getId() + ":" + at;
        String objectId = at;
        return (Optional)this.settingsCache.get((Object)cacheKey, () -> {
            PatternMatchingContentTreeCallback contentTreeCallback = new PatternMatchingContentTreeCallback(CONTRIBUTING_FILE_MATCHER, ContentTreeNode.Type.FILE);
            try {
                this.contentService.streamDirectory(repository, objectId, "", false, (ContentTreeCallback)contentTreeCallback, PageUtils.newRequest((int)0, (int)500));
            }
            catch (RuntimeException e) {
                log.warn("{}: An error occurred while searching for contributing guidelines", (Object)repository, (Object)e);
                return Optional.empty();
            }
            return contentTreeCallback.getMatch().map(ContentTreeNode::getPath);
        });
    }

    @Override
    @Nonnull
    public Optional<Path> getPath(@Nonnull Repository repository) {
        this.permissionValidationService.validateRepositoryAccessible(repository);
        return this.getPath(repository, null);
    }

    @EventListener
    public void onRefsChanged(RepositoryRefsChangedEvent event) {
        event.getRefChanges().forEach(refChange -> this.settingsCache.remove((Object)(event.getRepository().getId() + ":" + refChange.getRef().getId())));
    }
}

