/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.contributing;

import com.atlassian.bitbucket.content.AbstractContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;

public class PatternMatchingContentTreeCallback
extends AbstractContentTreeCallback {
    private final Pattern matchingName;
    private final ContentTreeNode.Type matchingType;
    private ContentTreeNode match;

    public PatternMatchingContentTreeCallback(Pattern matchingName, ContentTreeNode.Type type) {
        this.matchingType = type;
        this.matchingName = matchingName;
    }

    public Optional<ContentTreeNode> getMatch() {
        return Optional.ofNullable(this.match);
    }

    public boolean onTreeNode(@Nonnull ContentTreeNode contentTreeNode) throws IOException {
        if (this.matchingType.equals((Object)contentTreeNode.getType()) && this.matchingName.matcher(contentTreeNode.getPath().getName()).matches()) {
            this.match = contentTreeNode;
            return false;
        }
        return true;
    }
}

