/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.contributing;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.internal.contributing.ContributingGuidelinesService;
import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.view.TemplateRenderingException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class PullRequestCreateContributingGuidelinesFormFragment
implements ContextualFormFragment {
    private static final String MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-contributing-guidelines:pr-create-resources";
    private static final String TEMPLATE_NAME = "bitbucketPluginContributingGuidelines.internal.feature.pullRequestCreate.prCreateLink.link";
    private final ContributingGuidelinesService contributingService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public PullRequestCreateContributingGuidelinesFormFragment(ContributingGuidelinesService contributingService, SoyTemplateRenderer soyTemplateRenderer) {
        this.contributingService = contributingService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public void doError(@Nonnull Appendable appendable, @Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Collection<String>> fieldErrors, @Nonnull Map<String, Object> context) throws IOException {
        this.doView(appendable, context);
    }

    public void doView(@Nonnull Appendable appendable, @Nonnull Map<String, Object> context) throws IOException {
        Objects.requireNonNull(appendable, "appendable");
        Objects.requireNonNull(context, "context");
        ImmutableMap.Builder soyDataBuilder = ImmutableMap.builder();
        Repository toRepository = (Repository)context.get("toRepository");
        if (toRepository != null) {
            this.contributingService.getPath(toRepository).ifPresent(path -> soyDataBuilder.put((Object)"contributingGuidelinesPath", (Object)path.toString()));
        }
        try {
            this.soyTemplateRenderer.render(appendable, MODULE_KEY, TEMPLATE_NAME, (Map)soyDataBuilder.build());
        }
        catch (SoyException e) {
            throw new TemplateRenderingException("Failed to render bitbucketPluginContributingGuidelines.internal.feature.pullRequestCreate.prCreateLink.link", (Throwable)e);
        }
    }

    public void execute(@Nonnull Map<String, String[]> map, @Nonnull Map<String, Object> map1) {
    }

    public void validate(@Nonnull Map<String, String[]> map, @Nonnull ValidationErrors validationErrors, @Nonnull Map<String, Object> map1) {
    }
}

