/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server.internal.contributing.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.content.RestPath;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.server.internal.contributing.ContributingGuidelinesService;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@jakarta.ws.rs.Path(value="projects/{projectKey}/repos/{repositorySlug}")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class ContributingGuidelinesResource {
    private final ContributingGuidelinesService contributingService;
    private final I18nService i18nService;

    @Inject
    public ContributingGuidelinesResource(I18nService i18nService, ContributingGuidelinesService contributingService) {
        this.i18nService = i18nService;
        this.contributingService = contributingService;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response path(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="at") String at) {
        CacheControl cacheControl = CachePolicies.getCacheControlForObjectId((String)at);
        Optional<Path> contributingPath = StringUtils.isBlank((CharSequence)at) ? this.contributingService.getPath(repositoryResolver.getRepository()) : this.contributingService.getPath(repositoryResolver.getRepository(), at);
        return contributingPath.map(path -> ResponseFactory.ok((Object)new RestPath(path), (CacheControl)cacheControl)).orElseGet(() -> ResponseFactory.errors((Response.Status)Response.Status.NOT_FOUND, (RestErrors)new RestErrors(new RestErrorMessage(null, this.i18nService.getMessage("bitbucket.web.contributing.none", new Object[0]), NoSuchEntityException.class.getName())))).build();
    }
}

