/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestrictionService;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.dmz.user.DmzPermissionAdminService;
import com.atlassian.bitbucket.dmz.user.PermittedUserSearchRequest;
import com.atlassian.bitbucket.dmz.user.ProjectPermissionRequest;
import com.atlassian.bitbucket.dmz.user.ProjectPermissionSearchRequest;
import com.atlassian.bitbucket.dmz.user.RepositoryPermissionRequest;
import com.atlassian.bitbucket.dmz.user.RepositoryPermissionSearchRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.key.ssh.DefaultSshKeyService;
import com.atlassian.bitbucket.internal.key.ssh.InternalSshAccessKeyService;
import com.atlassian.bitbucket.internal.key.ssh.RestrictedSshAccessKey;
import com.atlassian.bitbucket.internal.key.ssh.SimpleRestrictedSshAccessKey;
import com.atlassian.bitbucket.internal.key.ssh.SimpleSshAccessKey;
import com.atlassian.bitbucket.internal.key.ssh.SshAccessKeyUtils;
import com.atlassian.bitbucket.internal.key.ssh.ValidatingSshKey;
import com.atlassian.bitbucket.internal.ssh.InternalSshKeyService;
import com.atlassian.bitbucket.internal.ssh.SshKeySearchRequest;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.ssh.DuplicateSshKeyException;
import com.atlassian.bitbucket.ssh.KeyType;
import com.atlassian.bitbucket.ssh.NoSuchSshKeyException;
import com.atlassian.bitbucket.ssh.SetSshAccessKeyRequest;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshAccessKeySearchRequest;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeyAccessDisabledException;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyEditedEvent;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyEvent;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyGrantedEvent;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyRevokedEvent;
import com.atlassian.bitbucket.ssh.event.SshKeyDeletedEvent;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.validation.Validator;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSshAccessKeyService
implements InternalSshAccessKeyService {
    static final int DEFAULT_PAGE_SIZE = 50;
    static final int LIMIT_PAGE_SIZE = 100;
    private static final int BATCH_SIZE = 100;
    private static final String GLOBAL_SCOPE_ACCESS_KEY = "GlobalScope is not applicable when searching for SSH access keys";
    private static final EnumSet<Permission> PROJECT_ACCESS_KEY_PERMS = Sets.newEnumSet(Arrays.asList(Permission.PROJECT_READ, Permission.PROJECT_WRITE), Permission.class);
    private static final EnumSet<Permission> REPO_ACCESS_KEY_PERMS = Sets.newEnumSet(Arrays.asList(Permission.REPO_READ, Permission.REPO_WRITE), Permission.class);
    private static final Logger log = LoggerFactory.getLogger(DefaultSshAccessKeyService.class);
    private final ActiveObjects ao;
    private final SshConfigurationService configurationService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final InternalSshKeyService keyService;
    private final DmzPermissionAdminService permissionAdminService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final DmzProjectSettingsRestrictionService projectSettingsRestrictionService;
    private final SecurityService securityService;
    private final UserAdminService userAdminService;
    private final EscalatedSecurityContext withAdmin;
    private final Validator validator;

    public DefaultSshAccessKeyService(SshConfigurationService configurationService, EventPublisher eventPublisher, I18nService i18nService, InternalSshKeyService keyService, DmzPermissionAdminService permissionAdminService, PermissionService permissionService, PermissionValidationService permissionValidationService, DmzProjectSettingsRestrictionService projectSettingsRestrictionService, SecurityService securityService, ActiveObjects ao, UserAdminService userAdminService, Validator validator) {
        this.ao = ao;
        this.configurationService = configurationService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.keyService = keyService;
        this.permissionAdminService = permissionAdminService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.securityService = securityService;
        this.userAdminService = userAdminService;
        this.validator = validator;
        this.withAdmin = securityService.withPermission(Permission.ADMIN, "Read in key accesses before filtering on visibility");
    }

    @Override
    public boolean existsForProject(@Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        if (!this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            return false;
        }
        return (Boolean)this.ao.executeInTransaction(() -> {
            Predicate<PermittedUser> serviceUserWithKeyPredicate = this.serviceUserWithSshKeyPredicate(Maps.newHashMap());
            PagedIterable usersWithPermission = new PagedIterable(request -> this.permissionAdminService.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.ProjectBuilder)new PermittedUserSearchRequest.Builder().project(project).userType(UserType.SERVICE)).build(), request), 100);
            return Iterables.any((Iterable)usersWithPermission, serviceUserWithKeyPredicate::test);
        });
    }

    @Override
    public boolean existsForRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
            return false;
        }
        return (Boolean)this.ao.executeInTransaction(() -> {
            Predicate<PermittedUser> serviceUserWithKeyPredicate = this.serviceUserWithSshKeyPredicate(Maps.newHashMap());
            PagedIterable usersWithPermission = new PagedIterable(request -> this.permissionAdminService.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.RepositoryBuilder)new PermittedUserSearchRequest.Builder().repository(repository).userType(UserType.SERVICE)).build(), request), 100);
            return Iterables.any((Iterable)usersWithPermission, serviceUserWithKeyPredicate::test);
        });
    }

    @Override
    @Nonnull
    public Page<SshAccessKey> findByKeyForProjects(int sshKeyId, @Nonnull PageRequest pageRequest) {
        return (Page)this.ao.executeInTransaction(() -> {
            SshKey key = this.getAndValidateServiceUserKey(sshKeyId);
            ApplicationUser serviceUser = key.getUser();
            PageProvider projectPageProvider = innerPageRequest -> (Page)this.withAdmin.call(() -> this.findPermittedProjects(key, serviceUser, innerPageRequest));
            return this.filterForVisibility((PageProvider<SshAccessKey>)projectPageProvider, pageRequest);
        });
    }

    @Override
    @Nonnull
    public Page<SshAccessKey> findByKeyForRepositories(int sshKeyId, @Nonnull PageRequest pageRequest) {
        return (Page)this.ao.executeInTransaction(() -> this.internalFindByKeyForRepositories(sshKeyId, pageRequest));
    }

    @Override
    @Nonnull
    public Page<RestrictedSshAccessKey> findByKeyForRepositoriesWithRestrictions(int sshKeyId, @Nonnull PageRequest pageRequest) {
        return (Page)this.ao.executeInTransaction(() -> this.hydrateWithRestrictions(this.internalFindByKeyForRepositories(sshKeyId, pageRequest)));
    }

    @VisibleForTesting
    Page<SshAccessKey> internalFindByKeyForRepositories(int sshKeyId, @Nonnull PageRequest pageRequest) {
        SshKey key = this.getAndValidateServiceUserKey(sshKeyId);
        ApplicationUser serviceUser = key.getUser();
        PageProvider repositoryPageProvider = innerPageRequest -> (Page)this.withAdmin.call(() -> this.findPermittedRepositories(key, serviceUser, innerPageRequest));
        return this.filterForVisibility((PageProvider<SshAccessKey>)repositoryPageProvider, pageRequest);
    }

    @Override
    @Nonnull
    public Optional<SshAccessKey> getByKeyAndProject(int sshKeyId, @Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        this.permissionValidationService.validateForProject(project, Permission.PROJECT_ADMIN);
        return (Optional)this.ao.executeInTransaction(() -> this.internalGetByProjectAndKey(sshKeyId, project, false));
    }

    @Override
    @Nonnull
    public Optional<SshAccessKey> getByKeyAndRepository(int sshKeyId, @Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        return (Optional)this.ao.executeInTransaction(() -> {
            Optional sshAccessKey = this.internalGetByRepositoryAndKey(sshKeyId, repository, false);
            if (!sshAccessKey.isPresent()) {
                sshAccessKey = (Optional)this.securityService.withPermission(Permission.PROJECT_ADMIN, (Object)repository.getProject(), "Finding access keys for this repository's project").call(() -> this.internalGetByProjectAndKey(sshKeyId, repository.getProject(), false));
            }
            return sshAccessKey;
        });
    }

    @EventListener
    public void onSshKeyDeleted(SshKeyDeletedEvent keyDeletedEvent) {
        SshKey key = keyDeletedEvent.getKey();
        if (this.isAccessKeyUser(key.getUser())) {
            this.securityService.withPermission(Permission.ADMIN, "Revoking all permissions for access key user because their SSH key has been deleted").call(() -> {
                this.permissionAdminService.revokeAllUserPermissions(key.getUser());
                return null;
            });
        }
    }

    @Override
    public void revoke(int sshKeyId, @Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        this.permissionValidationService.validateForProject(project, Permission.PROJECT_ADMIN);
        this.ao.executeInTransaction(() -> {
            this.internalGetByProjectAndKey(sshKeyId, project, true).ifPresent(accessKey -> {
                ApplicationUser serviceUser = accessKey.getKey().getUser();
                this.permissionAdminService.revokeAllProjectPermissions(project, serviceUser);
                log.debug("Access to project \"{}\" has been revoked for service user {}", (Object)project, (Object)serviceUser.getDisplayName());
                this.publish(new SshAccessKeyRevokedEvent(this, (SshAccessKey)accessKey));
                this.keyService.removeIfOrphaned(accessKey.getKey(), serviceUser);
            });
            return null;
        });
    }

    @Override
    public void revoke(int sshKeyId, @Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        this.validateIsNotRestricted(repository.getProject(), "bitbucket.settingsrestriction.ssh.key.restrictionexists.delete");
        this.ao.executeInTransaction(() -> {
            this.internalGetByRepositoryAndKey(sshKeyId, repository, true).ifPresent(accessKey -> {
                ApplicationUser serviceUser = accessKey.getKey().getUser();
                this.permissionAdminService.revokeAllRepositoryPermissions(repository, serviceUser);
                log.debug("Access to repository \"{}\" has been revoked for service user {}", (Object)repository, (Object)serviceUser.getDisplayName());
                this.publish(new SshAccessKeyRevokedEvent(this, (SshAccessKey)accessKey));
                this.keyService.removeIfOrphaned(accessKey.getKey(), serviceUser);
            });
            return null;
        });
    }

    @Override
    public void revoke(int sshKeyId, @Nonnull Set<Repository> repositories, @Nonnull Set<Project> projects) {
        Objects.requireNonNull(repositories, "repositories");
        Objects.requireNonNull(projects, "projects");
        this.validateIsAdminOfRepos(repositories);
        this.validateIsAdminOfProjects(projects);
        this.validateIsNotRestricted(repositories);
        SshKey key = this.getServiceUserKey(sshKeyId);
        if (key == null) {
            return;
        }
        ApplicationUser serviceUser = key.getUser();
        ImmutableList resources = ImmutableList.builder().addAll(projects).addAll(repositories).build();
        if (!resources.isEmpty()) {
            for (List batch : Chainable.chain((Iterable)resources).partition(100)) {
                this.ao.executeInTransaction(() -> {
                    for (Object resource : batch) {
                        if (resource instanceof Project) {
                            this.permissionAdminService.revokeAllProjectPermissions((Project)resource, serviceUser);
                            continue;
                        }
                        this.permissionAdminService.revokeAllRepositoryPermissions((Repository)resource, serviceUser);
                    }
                    this.keyService.removeIfOrphaned(key, serviceUser);
                    return null;
                });
            }
        }
    }

    @Override
    @Nonnull
    public Page<SshAccessKey> search(@Nonnull SshAccessKeySearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Scope scope = searchRequest.getScope();
        this.validateIsAdminForScope(scope);
        if (scope instanceof ProjectScope || !searchRequest.isEffective()) {
            return ((Page)this.ao.executeInTransaction(() -> PageUtils.filterPages(this.explicitAccessKeysProvider(scope), this.permissionFilter(searchRequest.getMinimumPermission()).and(this.labelFilter(searchRequest.getLabelPrefix())), (PageRequest)this.limit(pageRequest)))).transform(Optional::get);
        }
        return ((Page)this.ao.executeInTransaction(() -> PageUtils.filterPages(this.effectiveAccessKeysByLabelProvider(((RepositoryScope)scope).getRepository(), searchRequest.getLabelPrefix()), this.permissionFilter(searchRequest.getMinimumPermission()), (PageRequest)this.limit(pageRequest)))).transform(Optional::get);
    }

    @Override
    @Nonnull
    public SshAccessKey set(final @Nonnull SetSshAccessKeyRequest request) {
        if (!this.isAccessKeysEnabled()) {
            throw new SshKeyAccessDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.access.disabled", new Object[0]));
        }
        final Integer keyId = request.getKeyId();
        if (keyId == null) {
            ValidationUtils.validate((Validator)this.validator, (Object)new ValidatingSshKey(request.getKeyExpiryDays(), request.getKeyLabel(), request.getKeyText()), (Class[])new Class[0]);
        }
        final Scope scope = request.getScope();
        this.validateIsAdminForScope(scope);
        if (scope instanceof RepositoryScope) {
            Repository repository = ((RepositoryScope)scope).getRepository();
            this.validateIsNotRestricted(repository.getProject(), "bitbucket.settingsrestriction.ssh.key.restrictionexists.create");
        }
        return (SshAccessKey)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<SshAccessKey>(){

            public SshAccessKey doInTransaction() {
                SshKey key = keyId == null ? DefaultSshAccessKeyService.this.getOrCreateServiceUserKey(request.getKeyText(), request.getKeyLabel(), request.getKeyExpiryDays()) : DefaultSshAccessKeyService.this.getAndValidateServiceUserKey(keyId);
                Permission existingPermission = DefaultSshAccessKeyService.this.getPermissionForScope(key, scope);
                Permission newPermission = request.getPermission();
                if (existingPermission != null && existingPermission == newPermission) {
                    throw new DuplicateSshKeyException(DefaultSshAccessKeyService.this.i18nService.createKeyedMessage(scope instanceof ProjectScope ? "bitbucket.service.ssh.key.project.inuse" : "bitbucket.service.ssh.key.repository.inuse", new Object[0]));
                }
                DefaultSshAccessKeyService.this.setPermissionForScope(key, newPermission, scope);
                SshAccessKey newAccessKey = DefaultSshAccessKeyService.this.createAccessKeyForScope(key, scope, newPermission);
                if (keyId == null) {
                    DefaultSshAccessKeyService.this.publish(new SshAccessKeyGrantedEvent(this, newAccessKey));
                } else {
                    SimpleSshAccessKey oldAccessKey = new SimpleSshAccessKey(key, newAccessKey.getResource(), existingPermission);
                    DefaultSshAccessKeyService.this.publish(new SshAccessKeyEditedEvent(newAccessKey, oldAccessKey, this));
                }
                return newAccessKey;
            }
        });
    }

    private SshAccessKey createAccessKeyForScope(final SshKey key, Scope scope, final Permission newPermission) {
        return (SshAccessKey)scope.accept((ScopeVisitor)new ScopeVisitor<SshAccessKey>(){

            public SshAccessKey visit(@Nonnull ProjectScope scope) {
                return new SimpleSshAccessKey(key, scope.getProject(), newPermission);
            }

            public SshAccessKey visit(@Nonnull RepositoryScope scope) {
                return new SimpleSshAccessKey(key, scope.getRepository(), newPermission);
            }
        });
    }

    private Function<SshKey, Optional<SshAccessKey>> createAccessKeyFunction(Repository repository) {
        HashMap userToPermissionCache = new HashMap();
        return key -> {
            Permission permission = userToPermissionCache.computeIfAbsent(key.getUser(), user -> {
                if (!this.isAccessKeyUser((ApplicationUser)user)) {
                    return null;
                }
                if (this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_READ)) {
                    return this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_WRITE) ? Permission.REPO_WRITE : Permission.REPO_READ;
                }
                return null;
            });
            if (permission != null) {
                return Optional.of(new SimpleSshAccessKey((SshKey)key, repository, permission));
            }
            return Optional.empty();
        };
    }

    private Permission getPermissionForScope(final SshKey key, Scope scope) {
        return (Permission)scope.accept((ScopeVisitor)new ScopeVisitor<Permission>(){

            public Permission visit(@Nonnull GlobalScope scope) {
                throw new IllegalArgumentException("GlobalScope is not applicable for SshAccess keys");
            }

            public Permission visit(@Nonnull ProjectScope scope) {
                return DefaultSshAccessKeyService.this.permissionAdminService.getProjectPermission(((ProjectPermissionRequest.Builder)new ProjectPermissionRequest.Builder().user(key.getUser())).project(scope.getProject()).build());
            }

            public Permission visit(@Nonnull RepositoryScope scope) {
                return DefaultSshAccessKeyService.this.permissionAdminService.getRepositoryPermission(((RepositoryPermissionRequest.Builder)new RepositoryPermissionRequest.Builder().user(key.getUser())).repository(scope.getRepository()).build());
            }
        });
    }

    private Page<RestrictedSshAccessKey> hydrateWithRestrictions(Page<SshAccessKey> accessKeys) {
        Set projects = (Set)accessKeys.stream().map(key -> {
            Object resource = key.getResource();
            if (!(resource instanceof Repository)) {
                throw new IllegalArgumentException("Unexpected access key resource type: " + resource.getClass().getName());
            }
            return ((Repository)resource).getProject();
        }).collect(MoreCollectors.toImmutableSet());
        Set readOnlyProjects = (Set)this.projectSettingsRestrictionService.getRestrictedProjects((Collection)projects, ProjectSettingsRestrictionKeys.ACCESS_KEYS).stream().filter(id -> !this.permissionService.hasProjectPermission(id.intValue(), Permission.PROJECT_ADMIN)).collect(MoreCollectors.toImmutableSet());
        return accessKeys.transform(key -> {
            Project project = ((Repository)key.getResource()).getProject();
            return new SimpleRestrictedSshAccessKey(key.getKey(), key.getResource(), key.getPermission(), readOnlyProjects.contains(project.getId()));
        });
    }

    private PageProvider<Optional<SshAccessKey>> effectiveAccessKeysByLabelProvider(Repository repository, String labelPrefix) {
        Objects.requireNonNull(repository, "repository");
        SshKeySearchRequest request = new SshKeySearchRequest.Builder().labelPrefix(labelPrefix).keyType(KeyType.ACCESS_KEY).build();
        return pageRequest -> this.keyService.search(request, pageRequest).transform(this.createAccessKeyFunction(repository));
    }

    private PageProvider<Optional<SshAccessKey>> explicitAccessKeysProvider(Scope scope) {
        PermittedUserSearchRequest userSearchRequest = (PermittedUserSearchRequest)scope.accept((ScopeVisitor)new ScopeVisitor<PermittedUserSearchRequest>(this){

            public PermittedUserSearchRequest visit(@Nonnull GlobalScope scope) {
                throw new IllegalArgumentException(DefaultSshAccessKeyService.GLOBAL_SCOPE_ACCESS_KEY);
            }

            public PermittedUserSearchRequest visit(@Nonnull ProjectScope scope) {
                return ((PermittedUserSearchRequest.Builder)new PermittedUserSearchRequest.Builder().userType(UserType.SERVICE)).project(scope.getProject()).build();
            }

            public PermittedUserSearchRequest visit(@Nonnull RepositoryScope scope) {
                return ((PermittedUserSearchRequest.Builder)new PermittedUserSearchRequest.Builder().userType(UserType.SERVICE)).repository(scope.getRepository()).build();
            }
        });
        Object resource = scope.accept((ScopeVisitor)new ScopeVisitor<Object>(this){

            public Object visit(@Nonnull GlobalScope scope) {
                throw new IllegalArgumentException(DefaultSshAccessKeyService.GLOBAL_SCOPE_ACCESS_KEY);
            }

            public Project visit(@Nonnull ProjectScope scope) {
                return scope.getProject();
            }

            public Repository visit(@Nonnull RepositoryScope scope) {
                return scope.getRepository();
            }
        });
        HashMap userIdToKeyCache = new HashMap();
        return pageRequest -> this.permissionAdminService.searchUsers(userSearchRequest, pageRequest).transform(permittedUser -> {
            ApplicationUser user = permittedUser.getUser();
            SshKey key = userIdToKeyCache.computeIfAbsent(user.getId(), userId -> (SshKey)Iterables.getOnlyElement((Iterable)((Iterable)this.withAdmin.call(() -> this.keyService.findAllForUser(user, DefaultSshKeyService.PAGE_REQUEST_OF_1).getValues())), null));
            return key == null ? Optional.empty() : Optional.of(new SimpleSshAccessKey(key, resource, permittedUser.getPermission()));
        });
    }

    private Page<SshAccessKey> filterForVisibility(PageProvider<SshAccessKey> provider, PageRequest pageRequest) {
        return PageUtils.filterPages(provider, this::isAdminOfResource, (PageRequest)this.limit(pageRequest));
    }

    private Page<SshAccessKey> findPermittedProjects(SshKey key, ApplicationUser serviceUser, PageRequest pageRequest) {
        return this.permissionAdminService.searchProjects(((ProjectPermissionSearchRequest.Builder)new ProjectPermissionSearchRequest.Builder().user(serviceUser)).build(), pageRequest).transform(projectPermission -> new SimpleSshAccessKey(key, projectPermission.getProject(), projectPermission.getPermission()));
    }

    private Page<SshAccessKey> findPermittedRepositories(SshKey key, ApplicationUser serviceUser, PageRequest pageRequest) {
        return this.permissionAdminService.searchRepositories(((RepositoryPermissionSearchRequest.Builder)new RepositoryPermissionSearchRequest.Builder().user(serviceUser)).build(), pageRequest).transform(repositoryPermission -> new SimpleSshAccessKey(key, repositoryPermission.getRepository(), repositoryPermission.getPermission()));
    }

    private SshKey getAndValidateServiceUserKey(int sshKeyId) {
        SshKey key = (SshKey)this.withAdmin.call(() -> this.keyService.getById(sshKeyId));
        if (key == null || !this.isAccessKeyUser(key.getUser())) {
            throw new NoSuchSshKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.nosuchkey", new Object[0]));
        }
        return key;
    }

    private SshKey getOrCreateServiceUserKey(String keyText, String label, Integer expiryDays) {
        PublicKey publicKey = KeyUtils.getPublicKey(keyText);
        SshKey key = this.keyService.getByPublicKey(publicKey);
        if (key != null) {
            ApplicationUser user = key.getUser();
            if (user == null) {
                this.keyService.remove(key.getId());
                key = null;
            } else if (!this.isAccessKeyUser(user)) {
                throw new DuplicateSshKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.duplicate", new Object[]{user.getName()}));
            }
        }
        if (key == null) {
            ServiceUser serviceUser = this.userAdminService.createServiceUser(((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)new ServiceUserCreateRequest.Builder().active(true)).displayName(SshAccessKeyUtils.generateServiceUserDisplayName(keyText, label))).label("access-key")).build());
            key = (SshKey)this.withAdmin.call(() -> this.keyService.addForServiceUser(serviceUser, keyText, label, expiryDays));
        }
        return key;
    }

    private SshKey getServiceUserKey(int sshKeyId) {
        SshKey key = (SshKey)this.withAdmin.call(() -> this.keyService.getById(sshKeyId));
        if (key != null && !this.isAccessKeyUser(key.getUser())) {
            return null;
        }
        return key;
    }

    private Optional<SshAccessKey> internalGetByProjectAndKey(int sshKeyId, Project project, boolean validate) {
        SshKey key;
        SshKey sshKey = key = validate ? this.getAndValidateServiceUserKey(sshKeyId) : this.getServiceUserKey(sshKeyId);
        if (key == null) {
            return Optional.empty();
        }
        ApplicationUser serviceUser = key.getUser();
        Permission permission = null;
        if (serviceUser != null) {
            permission = this.permissionAdminService.getProjectPermission(((ProjectPermissionRequest.Builder)new ProjectPermissionRequest.Builder().user(serviceUser)).project(project).build());
        }
        return permission == null || !PROJECT_ACCESS_KEY_PERMS.contains(permission) ? Optional.empty() : Optional.of(new SimpleSshAccessKey(key, project, permission));
    }

    private Optional<SshAccessKey> internalGetByRepositoryAndKey(int sshKeyId, Repository repository, boolean validate) {
        SshKey key;
        SshKey sshKey = key = validate ? this.getAndValidateServiceUserKey(sshKeyId) : this.getServiceUserKey(sshKeyId);
        if (key == null) {
            return Optional.empty();
        }
        ApplicationUser serviceUser = key.getUser();
        Permission permission = null;
        if (serviceUser != null) {
            permission = this.permissionAdminService.getRepositoryPermission(((RepositoryPermissionRequest.Builder)new RepositoryPermissionRequest.Builder().user(serviceUser)).repository(repository).build());
        }
        return permission == null || !REPO_ACCESS_KEY_PERMS.contains(permission) ? Optional.empty() : Optional.of(new SimpleSshAccessKey(key, repository, permission));
    }

    private boolean isAccessKeyUser(ApplicationUser user) {
        return user != null && (Boolean)user.accept((ApplicationUserVisitor)new AbstractApplicationUserVisitor<Boolean>(this){

            public Boolean visit(@Nonnull ServiceUser user) {
                return "access-key".equals(user.getLabel());
            }

            protected Boolean defaultValue(@Nonnull ApplicationUser user) {
                return false;
            }
        }) != false;
    }

    private boolean isAccessKeysEnabled() {
        return this.configurationService.getConfiguration().isAccessKeysEnabled();
    }

    private boolean isAdminOfResource(SshAccessKey accessKey) {
        Object resource = accessKey.getResource();
        if (resource instanceof Project) {
            return this.permissionService.hasProjectPermission((Project)resource, Permission.PROJECT_ADMIN);
        }
        if (resource instanceof Repository) {
            return this.permissionService.hasRepositoryPermission((Repository)resource, Permission.REPO_ADMIN);
        }
        throw new IllegalArgumentException("Unexpected access key resource type: " + resource.getClass().getName());
    }

    private Predicate<Optional<SshAccessKey>> labelFilter(String labelPrefix) {
        String prefix = StringUtils.trimToNull((String)labelPrefix);
        if (prefix == null) {
            return Optional::isPresent;
        }
        return accessKey -> accessKey.map(k -> StringUtils.startsWith((CharSequence)k.getKey().getLabel(), (CharSequence)prefix)).orElse(false);
    }

    private PageRequest limit(PageRequest pageRequest) {
        return pageRequest == null ? new PageRequestImpl(0, 50) : pageRequest.buildRestrictedPageRequest(100);
    }

    private Predicate<Optional<SshAccessKey>> permissionFilter(@Nonnull Permission minimumPermission) {
        return accessKey -> accessKey.map(k -> minimumPermission.getInheritingPermissions().contains(k.getPermission())).orElse(false);
    }

    private void publish(SshAccessKeyEvent event) {
        this.eventPublisher.publish((Object)event);
    }

    private Predicate<PermittedUser> serviceUserWithSshKeyPredicate(Map<Integer, SshKey> userIdToKeyCache) {
        return value -> {
            ApplicationUser user = value.getUser();
            if (user.getType() == UserType.NORMAL) {
                return false;
            }
            SshKey key = userIdToKeyCache.computeIfAbsent(user.getId(), userId -> (SshKey)Iterables.getOnlyElement((Iterable)((Iterable)this.withAdmin.call(() -> this.keyService.findAllForUser(value.getUser(), DefaultSshKeyService.PAGE_REQUEST_OF_1).getValues())), null));
            return key != null;
        };
    }

    private void setPermissionForScope(final SshKey key, final Permission permission, Scope scope) {
        final SetPermissionRequest.Builder permRequestBuilder = new SetPermissionRequest.Builder().user(key.getUser());
        scope.accept((ScopeVisitor)new ScopeVisitor<Permission>(){

            public Permission visit(@Nonnull GlobalScope scope) {
                throw new IllegalArgumentException(DefaultSshAccessKeyService.GLOBAL_SCOPE_ACCESS_KEY);
            }

            public Permission visit(@Nonnull ProjectScope scope) {
                Project project = scope.getProject();
                DefaultSshAccessKeyService.this.permissionAdminService.setPermission(permRequestBuilder.projectPermission(permission, project).build());
                log.debug("Service user {} added ssh access key for project \"{}\"", (Object)key.getUser().getName(), (Object)project);
                return null;
            }

            public Permission visit(@Nonnull RepositoryScope scope) {
                Repository repository = scope.getRepository();
                DefaultSshAccessKeyService.this.permissionAdminService.setPermission(permRequestBuilder.repositoryPermission(permission, repository).build());
                log.debug("Service user {} added ssh access key for project \"{}\"", (Object)key.getUser().getName(), (Object)repository);
                return null;
            }
        });
    }

    private void validateIsAdminForScope(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Scope>(){

            public Scope visit(@Nonnull GlobalScope scope) {
                throw new IllegalArgumentException("GlobalScope is not applicable for SshAccess keys");
            }

            public Scope visit(@Nonnull ProjectScope scope) {
                DefaultSshAccessKeyService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Scope visit(@Nonnull RepositoryScope scope) {
                DefaultSshAccessKeyService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateIsAdminOfProjects(Collection<Project> projects) {
        for (Project project : projects) {
            this.permissionValidationService.validateForProject(project, Permission.PROJECT_ADMIN);
        }
    }

    private void validateIsAdminOfRepos(Collection<Repository> repositories) {
        for (Repository repository : repositories) {
            this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        }
    }

    private void validateIsNotRestricted(Project project, String errorKey) {
        if (!this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            this.projectSettingsRestrictionService.get(project, ProjectSettingsRestrictionKeys.ACCESS_KEYS).ifPresent(restriction -> {
                throw new ForbiddenException(this.i18nService.createKeyedMessage(errorKey, new Object[0]));
            });
        }
    }

    private void validateIsNotRestricted(Collection<Repository> repositories) {
        if (repositories.isEmpty()) {
            return;
        }
        Set projectsWithoutProjectAdmin = (Set)repositories.stream().map(Repository::getProject).distinct().filter(project -> !this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)).collect(MoreCollectors.toImmutableSet());
        if (!projectsWithoutProjectAdmin.isEmpty() && this.projectSettingsRestrictionService.hasRestrictions((Collection)projectsWithoutProjectAdmin, ProjectSettingsRestrictionKeys.ACCESS_KEYS)) {
            throw new ForbiddenException(this.i18nService.createKeyedMessage("bitbucket.settingsrestriction.ssh.key.restrictionexists.delete.bulk", new Object[0]));
        }
    }
}

