/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.user.DmzPermissionAdminService;
import com.atlassian.bitbucket.dmz.user.ProjectPermissionSearchRequest;
import com.atlassian.bitbucket.dmz.user.RepositoryPermissionSearchRequest;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.key.ssh.ValidatingSshKey;
import com.atlassian.bitbucket.internal.key.ssh.dao.AoSshKey;
import com.atlassian.bitbucket.internal.key.ssh.dao.SshKeyDao;
import com.atlassian.bitbucket.internal.key.ssh.dao.SshKeySearchCriteria;
import com.atlassian.bitbucket.internal.ssh.InternalSshKeyService;
import com.atlassian.bitbucket.internal.ssh.SshKeySearchRequest;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.ssh.DuplicateSshKeyException;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeySettingsService;
import com.atlassian.bitbucket.ssh.event.SshKeyCreatedEvent;
import com.atlassian.bitbucket.ssh.event.SshKeyDeletedEvent;
import com.atlassian.bitbucket.ssh.event.SshKeyEditedEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionCallback;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Validator;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Clock;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSshKeyService
implements InternalSshKeyService {
    static final int DEFAULT_PAGE_LIMIT = 25;
    static final int LIMIT = 100;
    static final PageRequest PAGE_REQUEST_OF_1 = PageUtils.newRequest((int)0, (int)1);
    private static final Logger log = LoggerFactory.getLogger(DefaultSshKeyService.class);
    private final ActiveObjects ao;
    private final AuthenticationContext authenticationContext;
    private final Clock clock;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final SshKeyDao keyDao;
    private final DmzPermissionAdminService permissionAdminService;
    private final PermissionService permissionService;
    private final SecurityService securityService;
    private final SshKeySettingsService sshKeySettingsService;
    private final UserService userService;
    private final Validator validator;

    public DefaultSshKeyService(ActiveObjects ao, AuthenticationContext authContext, Clock clock, EventPublisher eventPublisher, I18nService i18nService, SshKeyDao keyDao, DmzPermissionAdminService permissionAdminService, PermissionService permissionService, SecurityService securityService, SshKeySettingsService sshKeySettingsService, UserService userService, Validator validator) {
        this.ao = ao;
        this.authenticationContext = authContext;
        this.clock = clock;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.keyDao = keyDao;
        this.permissionAdminService = permissionAdminService;
        this.permissionService = permissionService;
        this.securityService = securityService;
        this.sshKeySettingsService = sshKeySettingsService;
        this.userService = userService;
        this.validator = validator;
    }

    @Override
    @Nonnull
    public SshKey addForUser(@Nonnull ApplicationUser user, @Nonnull String keyText) {
        return this.addForUser(user, keyText, null);
    }

    @Override
    @Nonnull
    public SshKey addForUser(@Nonnull ApplicationUser user, @Nonnull String keyText, @Nullable String keyLabel) {
        return this.addForUser(user, keyText, null, null);
    }

    @Override
    @Nonnull
    public SshKey addForUser(@Nonnull ApplicationUser user, @Nonnull String keyText, @Nullable String keyLabel, @Nullable Integer expiryDays) {
        if (user.getType() != UserType.NORMAL) {
            throw this.newUnauthorizedException();
        }
        return this.internalAddForUser(user, keyText, keyLabel, expiryDays);
    }

    @Override
    @Nonnull
    public SshKey addForServiceUser(@Nonnull ServiceUser user, @Nonnull String keyText, @Nullable String keyLabel, @Nullable Integer expiryDays) {
        return this.internalAddForUser((ApplicationUser)user, keyText, keyLabel, expiryDays);
    }

    @Override
    public boolean canEditSshKeyForUser(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        return this.permissionService.hasUserPermission(user, Permission.USER_ADMIN) || user.getType() != UserType.NORMAL && this.permissionService.hasGlobalPermission(Permission.ADMIN);
    }

    @Override
    @Nonnull
    public Page<SshKey> findAllForUser(final @Nonnull ApplicationUser user, final @Nullable PageRequest pageRequest) {
        this.checkCanEditSshKeyForUser(user);
        return (Page)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Page<SshKey>>(){

            public Page<SshKey> doInTransaction() {
                return DefaultSshKeyService.this.initialize(DefaultSshKeyService.this.keyDao.findByUser(user.getId(), DefaultSshKeyService.this.limit(pageRequest)), user);
            }
        });
    }

    @Override
    @Nonnull
    public Page<SshKey> search(@Nonnull SshKeySearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request cannot be null");
        String labelPrefix = request.getLabelPrefix().map(StringUtils::trimToEmpty).orElse(null);
        SshKeySearchCriteria criteria = new SshKeySearchCriteria.Builder().labelPrefix(labelPrefix).keyType(request.getKeyType().orElse(null)).build();
        return (Page)this.ao.executeInTransaction(() -> this.initialize(this.keyDao.search(criteria, pageRequest)));
    }

    @Override
    @Nullable
    public ApplicationUser findUserByPublicKey(final @Nonnull PublicKey key) {
        Objects.requireNonNull(key, "key");
        return DefaultSshKeyService.isValidKeyType(key) ? (ApplicationUser)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<ApplicationUser>(){

            public ApplicationUser doInTransaction() {
                AoSshKey sshKey = DefaultSshKeyService.this.initialize(DefaultSshKeyService.this.keyDao.getByUserPublicKey(key));
                return sshKey == null ? null : sshKey.getUser();
            }
        }) : null;
    }

    @Override
    @Nullable
    public SshKey getByPublicKey(@Nonnull PublicKey key) {
        Objects.requireNonNull(key, "key");
        return DefaultSshKeyService.isValidKeyType(key) ? (SshKey)this.ao.executeInTransaction(() -> this.initialize(this.keyDao.getByPublicKey(key))) : null;
    }

    @Override
    @Nullable
    public SshKey getById(final int id) {
        return (SshKey)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AoSshKey>(){

            public AoSshKey doInTransaction() {
                AoSshKey key = DefaultSshKeyService.this.initialize(DefaultSshKeyService.this.keyDao.getById(id));
                if (key != null) {
                    if (key.getUser() == null) {
                        DefaultSshKeyService.this.keyDao.delete(key);
                        return null;
                    }
                    DefaultSshKeyService.this.checkCanEditSshKeyForUser(key.getUser());
                }
                return key;
            }
        });
    }

    @Override
    public boolean hasSshKey(final @Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        this.checkCanEditSshKeyForUser(user);
        return (Boolean)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                return DefaultSshKeyService.this.keyDao.existsForUser(user.getId());
            }
        });
    }

    @EventListener
    public void onUserDeleted(UserCleanupEvent event) {
        this.doRemoveAllForUser(event.getDeletedUser());
    }

    @Override
    public void remove(final int id) {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                AoSshKey sshKey = DefaultSshKeyService.this.initialize(DefaultSshKeyService.this.keyDao.getById(id));
                if (sshKey != null) {
                    if (sshKey.getUser() != null) {
                        DefaultSshKeyService.this.checkCanEditSshKeyForUser(sshKey.getUser());
                    }
                    DefaultSshKeyService.this.keyDao.delete(sshKey);
                    DefaultSshKeyService.this.eventPublisher.publish((Object)new SshKeyDeletedEvent(this, sshKey));
                }
                return null;
            }
        });
    }

    @Override
    public void removeAllForUser(@Nonnull ApplicationUser user) {
        this.checkCanEditSshKeyForUser(user);
        this.doRemoveAllForUser(user);
    }

    @Override
    public boolean removeIfOrphaned(final @Nonnull SshKey key, final @Nonnull ApplicationUser serviceUser) {
        return (Boolean)this.securityService.withPermission(Permission.ADMIN, "Checking SSH key to remove orphans").call((Operation)new UncheckedOperation<Boolean>(){

            public Boolean perform() {
                if (this.countProjects() == 0 && this.countRepositories() == 0) {
                    DefaultSshKeyService.this.remove(key.getId());
                    return true;
                }
                return false;
            }

            private int countProjects() {
                return DefaultSshKeyService.this.permissionAdminService.searchProjects(((ProjectPermissionSearchRequest.Builder)new ProjectPermissionSearchRequest.Builder().user(serviceUser)).build(), PAGE_REQUEST_OF_1).getSize();
            }

            private int countRepositories() {
                return DefaultSshKeyService.this.permissionAdminService.searchRepositories(((RepositoryPermissionSearchRequest.Builder)new RepositoryPermissionSearchRequest.Builder().user(serviceUser)).build(), PAGE_REQUEST_OF_1).getSize();
            }
        });
    }

    @Override
    public void setLastAuthenticated(@Nonnull Date date, @Nonnull PublicKey publicKey) {
        Objects.requireNonNull(date, "date");
        Objects.requireNonNull(publicKey, "publicKey");
        this.ao.executeInTransaction(() -> {
            AoSshKey sshKey = this.initialize(this.keyDao.getByPublicKey(publicKey));
            if (sshKey == null) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.nosuchkey", new Object[0]));
            }
            if (sshKey.getUser() == null) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.user.notfound", new Object[0]));
            }
            this.keyDao.setLastAuthenticated(date, sshKey);
            return null;
        });
    }

    @Override
    public void setKeyLabel(int keyId, @Nonnull String keyLabel) {
        Objects.requireNonNull(keyLabel, "keyLabel");
        this.ao.executeInTransaction(() -> {
            AoSshKey oldSshKey = this.initialize(this.keyDao.getById(keyId));
            AoSshKey sshKey = this.initialize(this.keyDao.getById(keyId));
            if (sshKey == null || oldSshKey == null) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.nosuchkey", new Object[0]));
            }
            this.checkCanEditSshKeyForUser(sshKey.getUser());
            this.keyDao.setLabel(sshKey, keyLabel.trim());
            this.eventPublisher.publish((Object)new SshKeyEditedEvent(sshKey, oldSshKey, this));
            return null;
        });
    }

    protected void doRemoveAllForUser(final @Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                log.debug("\"{}\" removing all ssh key access entries for user \"{}\"", (Object)DefaultSshKeyService.this.currentUserName(), (Object)user.getDisplayName());
                PageRequest request = PageUtils.newRequest((int)0, (int)100);
                Page<AoSshKey> page = DefaultSshKeyService.this.keyDao.findByUser(user.getId(), request);
                while (page != null && page.getSize() > 0) {
                    for (AoSshKey key : page.getValues()) {
                        DefaultSshKeyService.this.keyDao.delete(key);
                        DefaultSshKeyService.this.eventPublisher.publish((Object)new SshKeyDeletedEvent(this, DefaultSshKeyService.this.initialize(key, user)));
                    }
                    page = page.getIsLastPage() ? null : DefaultSshKeyService.this.keyDao.findByUser(user.getId(), request);
                }
                log.debug("\"{}\" removed all ssh key access entries for user \"{}\"", (Object)DefaultSshKeyService.this.currentUserName(), (Object)user.getDisplayName());
                return null;
            }
        });
    }

    private void cleanupStaleKeyOrThrow(AoSshKey key) {
        ApplicationUser user = key.getUser();
        if (user != null) {
            log.debug("Duplicate key encountered with MD5 hash: {}, username: {}", (Object)key.getMD5(), (Object)user.getName());
            if (user.getType() == UserType.NORMAL) {
                throw new DuplicateSshKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.duplicate", new Object[]{user.getName()}));
            }
            if (!this.removeIfOrphaned(key, user)) {
                throw new DuplicateSshKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.resource.usage", new Object[0]));
            }
        }
        log.info("Key with id {} is not assigned to a user. Deleting the key", (Object)key.getId());
        this.keyDao.delete(key);
        this.eventPublisher.publish((Object)new SshKeyDeletedEvent(this, this.initialize(key)));
    }

    private SshKey internalAddForUser(final @Nonnull ApplicationUser user, final @Nonnull String keyText, final @Nullable String keyLabel, @Nullable Integer expiryDays) {
        Objects.requireNonNull(user, "user");
        if (!this.authenticationContext.isAuthenticated()) {
            throw this.newUnauthorizedException();
        }
        final Integer validExpiry = this.validateExpiryDays(expiryDays, this.sshKeySettingsService.getMaxExpiry());
        this.checkCanEditSshKeyForUser(user);
        ValidationUtils.validate((Validator)this.validator, (Object)new ValidatingSshKey(expiryDays, keyLabel, keyText), (Class[])new Class[0]);
        return (SshKey)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<SshKey>(){

            public SshKey doInTransaction() {
                PublicKey publicKey = KeyUtils.getPublicKey(keyText);
                if (!DefaultSshKeyService.this.sshKeySettingsService.meetsMinimumRestrictions(publicKey)) {
                    throw new ArgumentValidationException(DefaultSshKeyService.this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.auth.sshkey.requirementsNotMet", new Object[0]));
                }
                AoSshKey key = DefaultSshKeyService.this.initialize(DefaultSshKeyService.this.keyDao.getByPublicKey(publicKey));
                if (key != null) {
                    DefaultSshKeyService.this.cleanupStaleKeyOrThrow(key);
                }
                String label = StringUtils.isBlank((CharSequence)keyLabel) ? KeyUtils.getKeyComment(keyText) : keyLabel;
                Date createdDate = new Date(DefaultSshKeyService.this.clock.instant().toEpochMilli());
                AoSshKey newKey = DefaultSshKeyService.this.keyDao.create(user, keyText, label, createdDate, validExpiry);
                newKey = DefaultSshKeyService.this.initialize(newKey, user);
                log.debug("{} added an ssh key for {}", (Object)DefaultSshKeyService.this.currentUserName(), (Object)user.getName());
                DefaultSshKeyService.this.eventPublisher.publish((Object)new SshKeyCreatedEvent(this, newKey));
                return newKey;
            }
        });
    }

    private Integer validateExpiryDays(Integer expiryDays, Integer globalExpiryDays) {
        if (expiryDays == null) {
            return globalExpiryDays;
        }
        if (expiryDays <= 0) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.ssh.access.keys.error.expiry", new Object[]{expiryDays}));
        }
        if (globalExpiryDays != null && expiryDays > globalExpiryDays) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.ssh.access.keys.error.expirylargerthanglobal", new Object[]{expiryDays}));
        }
        return expiryDays;
    }

    private String currentUserName() {
        return this.authenticationContext.isAuthenticated() ? this.authenticationContext.getCurrentUser().getDisplayName() : "Anonymous user";
    }

    private PageRequest limit(PageRequest pageRequest) {
        return pageRequest == null ? PageUtils.newRequest((int)0, (int)25) : pageRequest.buildRestrictedPageRequest(100);
    }

    private Page<SshKey> initialize(Page<AoSshKey> keys, ApplicationUser knownOwner) {
        for (AoSshKey key : keys.getValues()) {
            this.initialize(key, knownOwner);
        }
        return PageUtils.asPageOf(SshKey.class, keys);
    }

    private Page<SshKey> initialize(Page<AoSshKey> keys) {
        HashMap<Integer, ApplicationUser> cache = new HashMap<Integer, ApplicationUser>();
        for (AoSshKey key : keys.getValues()) {
            ApplicationUser user = cache.computeIfAbsent(key.getUserId(), arg_0 -> ((UserService)this.userService).getUserById(arg_0));
            this.initialize(key, user);
        }
        return PageUtils.asPageOf(SshKey.class, keys);
    }

    private AoSshKey initialize(AoSshKey key) {
        return this.initialize(key, null);
    }

    private AoSshKey initialize(AoSshKey key, ApplicationUser knownUser) {
        RSAPublicKey rsaPublicKey;
        PublicKey publicKey;
        if (key == null) {
            return null;
        }
        ApplicationUser user = knownUser == null ? this.userService.getUserById(key.getUserId().intValue()) : knownUser;
        boolean undecodable = KeyUtils.isUndecodable(key);
        boolean rsaUnsafe = undecodable ? false : (publicKey = key.toPublicKey()) instanceof RSAPublicKey && KeyUtils.isRSAKeyFactorSmall(rsaPublicKey = (RSAPublicKey)publicKey);
        key.initialize(user, this.sshKeySettingsService.getFallbackCreatedDate(), undecodable, rsaUnsafe);
        return key;
    }

    private void checkCanEditSshKeyForUser(ApplicationUser user) {
        if (!this.canEditSshKeyForUser(user)) {
            throw this.newUnauthorizedException();
        }
    }

    private AuthorisationException newUnauthorizedException() {
        throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.edit.permissions.error", new Object[0]));
    }

    private static boolean isValidKeyType(PublicKey key) {
        if (key instanceof RSAPublicKey || key instanceof DSAPublicKey || key instanceof ECPublicKey || key instanceof SecurityKeyPublicKey || KeyUtils.isEdDSAKey(key)) {
            return true;
        }
        log.debug("Unsupported key type: {} (Class: {})", (Object)key.getAlgorithm(), (Object)key.getClass().getName());
        return false;
    }
}

