/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SshAccessKeyUtils {
    static final int MAX_LENGTH_KEY_IDENTIFIER = 64;

    @Nonnull
    public static String generateServiceUserDisplayName(@Nonnull String keyText, @Nullable String keyLabel) {
        Objects.requireNonNull(keyText, "keyText");
        return "Access Key User - " + SshAccessKeyUtils.getKeyIdentifier(keyText, keyLabel);
    }

    @Nonnull
    public static String getKeyIdentifier(@Nonnull String keyText, @Nullable String keyLabel) {
        if (StringUtils.isBlank((CharSequence)keyLabel)) {
            return StringUtils.abbreviateMiddle((String)keyText, (String)"...", (int)64);
        }
        return StringUtils.abbreviate((String)keyLabel, (int)64);
    }
}

