/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.key.ssh.dao.AoSshKey;
import com.atlassian.bitbucket.internal.key.ssh.dao.SshKeyDao;
import com.atlassian.bitbucket.internal.key.ssh.dao.SshKeySearchCriteria;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.ssh.KeyType;
import com.atlassian.bitbucket.ssh.StandardDigests;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoSshKeyDao
extends AbstractAoDao
implements SshKeyDao {
    private static final Logger log = LoggerFactory.getLogger(AoSshKeyDao.class);
    private static final ApplicationUserVisitor<KeyType> keyTypeVisitor = new AbstractApplicationUserVisitor<KeyType>(){

        public KeyType visit(@Nonnull ServiceUser user) {
            return "access-key".equals(user.getLabel()) ? KeyType.ACCESS_KEY : KeyType.SERVICE;
        }

        protected KeyType defaultValue(ApplicationUser user) {
            return KeyType.USER_KEY;
        }
    };

    public AoSshKeyDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public AoSshKey create(@Nonnull ApplicationUser user, @Nonnull String keyText, @Nullable String label, @Nonnull Date createdDate, @Nullable Integer expiryDays) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(createdDate, "createdDate");
        PublicKey publicKey = KeyUtils.getPublicKey(Objects.requireNonNull(keyText, "keyText"));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"KEY_TEXT", (Object)keyText);
        builder.put((Object)"KEY_MD5", (Object)StandardDigests.MD5.apply(this.getKeyBytes(publicKey)));
        builder.put((Object)"USER_ID", (Object)user.getId());
        builder.put((Object)"KEY_TYPE", user.accept(keyTypeVisitor));
        builder.put((Object)"CREATED_DATE", (Object)createdDate);
        if (label != null) {
            String trimmedLabel = StringUtils.left((String)label, (int)255);
            builder.put((Object)"LABEL", (Object)trimmedLabel);
            builder.put((Object)"LABEL_LOWER", (Object)trimmedLabel.toLowerCase(Locale.ROOT));
        }
        if (expiryDays != null) {
            builder.put((Object)"EXPIRY_DAYS", (Object)expiryDays);
        }
        return (AoSshKey)this.ao.create(AoSshKey.class, (Map)builder.build());
    }

    @Override
    public void delete(@Nonnull AoSshKey key) {
        this.ao.delete(new RawEntity[]{key});
    }

    @Override
    public void deleteAllForUser(int userId) {
        log.debug("Fetching ssh keys for user with id={}", (Object)userId);
        AoSshKey[] keys = (AoSshKey[])this.ao.find(AoSshKey.class, this.newUnorderedQuery("USER_ID = ?", userId));
        log.debug("There are {} ssh keys owned by user {} to delete", (Object)keys.length, (Object)userId);
        for (AoSshKey key : keys) {
            this.ao.delete(new RawEntity[]{key});
            log.debug("Deleted key with id={}", (Object)key.getId());
        }
    }

    @Override
    public boolean existsForAnyUser(@Nonnull PublicKey key) {
        byte[] remoteKey = this.getKeyBytes(key);
        String md5 = StandardDigests.MD5.apply(remoteKey);
        Query query = this.newUnorderedQuery("KEY_MD5 = ? and USER_ID is not null", md5);
        return Arrays.stream((AoSshKey[])this.ao.find(AoSshKey.class, query)).anyMatch(this.keyMatchesPublicKey(remoteKey));
    }

    @Override
    public boolean existsForUser(int userId) {
        return this.ao.count(AoSshKey.class, this.newUnorderedQuery("USER_ID = ?", userId)) > 0;
    }

    @Override
    @Nonnull
    public Page<AoSshKey> search(@Nonnull SshKeySearchCriteria request, @Nonnull PageRequest pageRequest) {
        Query query = Query.select();
        request.getLabelPrefix().ifPresent(labelPrefix -> {
            String escapeChar = "\\";
            labelPrefix = StringUtils.left((String)labelPrefix, (int)64).toLowerCase(Locale.ROOT);
            labelPrefix = StringUtils.replace((String)labelPrefix, (String)escapeChar, (String)(escapeChar + escapeChar));
            labelPrefix = StringUtils.replace((String)labelPrefix, (String)"%", (String)(escapeChar + "%"));
            labelPrefix = StringUtils.replace((String)labelPrefix, (String)"_", (String)(escapeChar + "_"));
            if (this.ao.moduleMetaData().getDatabaseType() == DatabaseType.MS_SQL) {
                labelPrefix = StringUtils.replace((String)labelPrefix, (String)"[", (String)(escapeChar + "["));
                labelPrefix = StringUtils.replace((String)labelPrefix, (String)"]", (String)(escapeChar + "]"));
            }
            boolean isHSQL = this.ao.moduleMetaData().getDatabaseType() == DatabaseType.HSQL;
            String escapeClause = isHSQL ? "ESCAPE CAST(? AS CHAR)" : "ESCAPE ?";
            AoSshKeyDao.appendToQuery(query, "LABEL_LOWER LIKE ? " + escapeClause, labelPrefix + "%", escapeChar);
        });
        request.getKeyType().ifPresent(keyType -> AoSshKeyDao.appendToQuery(query, "KEY_TYPE = ?", keyType));
        return this.pageQuery(AoSshKey.class, query, pageRequest);
    }

    @Override
    @Nonnull
    public Page<AoSshKey> findByUser(int userId, @Nonnull PageRequest pageRequest) {
        return this.pageQuery(AoSshKey.class, this.newQuery("USER_ID = ?", userId), pageRequest);
    }

    @Override
    public AoSshKey getById(int id) {
        return (AoSshKey)this.ao.get(AoSshKey.class, (Object)id);
    }

    @Override
    public AoSshKey getByPublicKey(@Nonnull PublicKey key) {
        byte[] remoteKey = this.getKeyBytes(key);
        String md5 = StandardDigests.MD5.apply(remoteKey);
        return this.findMatchingKey(remoteKey, this.newUnorderedQuery("KEY_MD5 = ?", md5));
    }

    @Override
    public AoSshKey getByUserPublicKey(@Nonnull PublicKey key) {
        byte[] remoteKey = this.getKeyBytes(key);
        String md5 = StandardDigests.MD5.apply(remoteKey);
        return this.findMatchingKey(remoteKey, this.newUnorderedQuery("KEY_MD5 = ? and USER_ID is not null", md5));
    }

    @Override
    public void setLabel(@Nonnull AoSshKey key, @Nonnull String keyLabel) {
        Objects.requireNonNull(key, "sshKey");
        Objects.requireNonNull(keyLabel, "keyLabel");
        String trimmedLabel = StringUtils.left((String)keyLabel, (int)255);
        key.setLabel(trimmedLabel);
        key.setLabelLower(trimmedLabel.toLowerCase(Locale.ROOT));
        key.save();
    }

    @Override
    public void setLastAuthenticated(@Nonnull Date authenticatedDate, @Nonnull AoSshKey key) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(authenticatedDate, "authenticatedDate");
        key.setLastAuthenticated(authenticatedDate);
        key.save();
    }

    private static void appendToQuery(Query query, String whereClause, Object ... whereParams) {
        StringBuilder builder = new StringBuilder();
        if (query.getWhereClause() != null) {
            builder.append(query.getWhereClause());
            builder.append(" AND ");
        }
        builder.append(whereClause);
        query.setWhereClause(builder.toString());
        if (whereParams.length > 0) {
            Object[] existingParams = query.getWhereParams();
            ArrayList params = new ArrayList();
            if (existingParams != null) {
                Collections.addAll(params, existingParams);
            }
            Collections.addAll(params, whereParams);
            query.setWhereParams(params.toArray());
        }
    }

    private AoSshKey findMatchingKey(byte[] remoteKey, Query query) {
        return Arrays.stream((AoSshKey[])this.ao.find(AoSshKey.class, query)).filter(this.keyMatchesPublicKey(remoteKey)).findFirst().orElse(null);
    }

    private byte[] getKeyBytes(PublicKey key) {
        byte[] keyBytes = key.getEncoded();
        return keyBytes == null ? KeyUtils.getKeyText(key).getBytes() : keyBytes;
    }

    private Predicate<AoSshKey> keyMatchesPublicKey(byte[] remoteKey) {
        return key -> Arrays.equals(remoteKey, this.getKeyBytes(key.toPublicKey()));
    }

    private Query newQuery(String clause, Object ... params) {
        return Query.select().from(AoSshKey.class).where(clause, params).order("ENTITY_ID");
    }

    private Query newUnorderedQuery(String clause, Object ... params) {
        return Query.select().from(AoSshKey.class).where(clause, params);
    }
}

