/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.dao;

import com.atlassian.bitbucket.internal.key.ssh.dao.AoSshKey;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.security.PublicKey;
import java.util.Date;

public class PartialSshKey {
    private final AoSshKey delegate;
    private ApplicationUser owner;
    private boolean rsaUnsafe;
    private boolean undecodable;

    public PartialSshKey(AoSshKey delegate) {
        this.delegate = delegate;
    }

    public ApplicationUser getUser() {
        return this.owner;
    }

    public void initialize(ApplicationUser owner, Date fallbackCreatedDate, boolean undecodable, boolean rsaUnsafe) {
        if (this.delegate.getCreatedDate() == null && fallbackCreatedDate != null) {
            this.delegate.setCreatedDate(fallbackCreatedDate);
        }
        this.owner = owner;
        this.undecodable = undecodable;
        this.rsaUnsafe = rsaUnsafe;
    }

    public boolean isRsaUnsafe() {
        return this.rsaUnsafe;
    }

    public boolean isUndecodable() {
        return this.undecodable;
    }

    @Nonnull
    public PublicKey toPublicKey() {
        return KeyUtils.getPublicKey(this.delegate.getText());
    }
}

