/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.dao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.key.ssh.dao.v0.AoSshKeyV0;
import com.atlassian.bitbucket.internal.key.ssh.dao.v1.AoSshAccessKeyV1;
import com.atlassian.bitbucket.internal.key.ssh.dao.v1.AoSshKeyV1;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;

public class MigrateToSshPublicKeyTableTask
implements ActiveObjectsUpgradeTask {
    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"This upgrade task can only upgrade from version 0 to 1");
        ao.migrateDestructively(new Class[]{AoSshKeyV0.class, AoSshKeyV1.class, AoSshAccessKeyV1.class});
        PagedIterable accessKeys = new PagedIterable(request -> PageUtils.createPage(Arrays.asList((AoSshKeyV0[])ao.find(AoSshKeyV0.class, AoUtils.restrict((Query)Query.select(), (PageRequest)request))), (PageRequest)request), 1000);
        for (AoSshKeyV0 accessKey : accessKeys) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"KEY_MD5", (Object)accessKey.getMD5());
            builder.put((Object)"KEY_TEXT", (Object)accessKey.getText());
            builder.put((Object)"USER_ID", (Object)accessKey.getUserId());
            String label = KeyUtils.getKeyComment(accessKey.getText());
            if (!StringUtils.isEmpty((CharSequence)label)) {
                builder.put((Object)"LABEL", (Object)StringUtils.left((String)label, (int)255));
            }
            ao.create(AoSshKeyV1.class, (Map)builder.build());
        }
    }
}

