/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.dao.v3;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.key.ssh.ResourceType;
import com.atlassian.bitbucket.internal.key.ssh.SshAccessKeyUtils;
import com.atlassian.bitbucket.internal.key.ssh.dao.v1.AoSshAccessKeyV1;
import com.atlassian.bitbucket.internal.key.ssh.dao.v1.AoSshKeyV1;
import com.atlassian.bitbucket.internal.key.ssh.dao.v3.AoSshKeyV3;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateAccessKeysToServiceUsersTask
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(MigrateAccessKeysToServiceUsersTask.class);
    private final PermissionAdminService permissionAdminService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final UserAdminService userAdminService;

    public MigrateAccessKeysToServiceUsersTask(PermissionAdminService permissionAdminService, ProjectService projectService, RepositoryService repositoryService, SecurityService securityService, UserAdminService userAdminService) {
        this.permissionAdminService = permissionAdminService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.userAdminService = userAdminService;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"3");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"2")), (Object)"This upgrade task can only upgrade from version 2 to 3");
        ao.migrateDestructively(new Class[]{AoSshKeyV1.class, AoSshAccessKeyV1.class});
        log.info("Migrating key accesses to service users and permissions");
        PagedIterable keys = new PagedIterable(request -> PageUtils.createPage(Arrays.asList((AoSshKeyV1[])ao.find(AoSshKeyV1.class, AoUtils.restrict((Query)Query.select().where("USER_ID is null", new Object[0]).order("ENTITY_ID"), (PageRequest)request))), (PageRequest)request), 1000);
        this.securityService.withPermission(Permission.ADMIN, "Migration of access keys to service users").call(() -> this.lambda$upgrade$1((Iterable)keys, ao));
        ao.migrateDestructively(new Class[]{AoSshKeyV3.class});
        log.info("Migrated key accesses to service users and permissions");
    }

    private Object migrate(Iterable<AoSshKeyV1> keys, ActiveObjects ao) {
        for (AoSshKeyV1 key : keys) {
            UnmodifiableIterator accessKeys = Iterators.forArray((Object[])key.getAccessEntries());
            if (accessKeys.hasNext()) {
                ServiceUser serviceUser = this.userAdminService.createServiceUser(((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)new ServiceUserCreateRequest.Builder().displayName(SshAccessKeyUtils.generateServiceUserDisplayName(key.getText(), key.getLabel()))).label("access-key")).build());
                key.setUserId(serviceUser.getId());
                key.save();
                while (accessKeys.hasNext()) {
                    this.grantPermission(serviceUser, (AoSshAccessKeyV1)accessKeys.next());
                }
                continue;
            }
            ao.delete(new RawEntity[]{key});
        }
        return null;
    }

    private void grantPermission(ServiceUser serviceUser, AoSshAccessKeyV1 accessKey) {
        SetPermissionRequest.Builder builder = new SetPermissionRequest.Builder().user((ApplicationUser)serviceUser);
        ResourceType type = accessKey.getType();
        if (type == ResourceType.PROJECT) {
            Permission permission = accessKey.isReadOnly() ? Permission.PROJECT_READ : Permission.PROJECT_WRITE;
            Project project = this.projectService.getById(accessKey.getResourceId().intValue());
            if (project == null) {
                log.warn("Key access {} relates to a project {} that no longer exists. Not migrating.", (Object)accessKey.getId(), (Object)accessKey.getResourceId());
                return;
            }
            builder.projectPermission(permission, project);
        } else if (type == ResourceType.REPOSITORY) {
            Permission permission = accessKey.isReadOnly() ? Permission.REPO_READ : Permission.REPO_WRITE;
            Repository repository = this.repositoryService.getById(accessKey.getResourceId().intValue());
            if (repository == null) {
                log.warn("Key access {} relates to a repository {} that no longer exists. Not migrating.", (Object)accessKey.getId(), (Object)accessKey.getResourceId());
                return;
            }
            builder.repositoryPermission(permission, repository);
        }
        this.permissionAdminService.setPermission(builder.build());
    }

    private /* synthetic */ Object lambda$upgrade$1(Iterable keys, ActiveObjects ao) throws RuntimeException {
        return this.migrate(keys, ao);
    }
}

