/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.dao.v4;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.key.ssh.SshAccessKeyUtils;
import com.atlassian.bitbucket.internal.key.ssh.dao.PartialSshKey;
import com.atlassian.bitbucket.internal.key.ssh.dao.v4.AoSshKeyV4;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.ssh.KeyType;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserUpdateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import net.java.ao.Accessor;
import net.java.ao.Implementation;
import net.java.ao.Mutator;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.Ignore;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyAccessKeysTypeTask
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(ApplyAccessKeysTypeTask.class);
    private final int pageSize;
    private final SecurityService securityService;
    private final UserAdminService userAdminService;
    private final UserService userService;

    ApplyAccessKeysTypeTask(SecurityService securityService, UserAdminService userAdminService, UserService userService, int pageSize) {
        this.securityService = securityService;
        this.userAdminService = userAdminService;
        this.userService = userService;
        this.pageSize = pageSize;
    }

    public ApplyAccessKeysTypeTask(SecurityService securityService, UserAdminService userAdminService, UserService userService) {
        this(securityService, userAdminService, userService, 1000);
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"4");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"3")), (Object)"This upgrade task can only upgrade from version 3 to 4");
        log.info("Migrating to add label_lower and key_type to keys.");
        ao.migrateDestructively(new Class[]{AoSshKeyV3ToV4.class});
        Query pageQuery = Query.select().where("KEY_TYPE is null", new Object[0]).order("ENTITY_ID").limit(this.pageSize + 1);
        PagedIterable keys = new PagedIterable(request -> PageUtils.createPage(Arrays.asList((AoSshKeyV3ToV4[])ao.find(AoSshKeyV3ToV4.class, pageQuery)), (PageRequest)request), this.pageSize);
        MigratingApplicationUserVisitor migratingVisitor = new MigratingApplicationUserVisitor();
        this.securityService.withPermission(Permission.ADMIN, "Migration of access keys to schema v4").call(() -> this.lambda$upgrade$1((Iterable)keys, migratingVisitor));
        ao.migrateDestructively(new Class[]{AoSshKeyV4.class});
        log.info("Migrated keys to add label_lower and key_type");
    }

    private /* synthetic */ Object lambda$upgrade$1(Iterable keys, MigratingApplicationUserVisitor migratingVisitor) throws RuntimeException {
        ArrayList<Integer> updatedServiceUsers = new ArrayList<Integer>();
        for (AoSshKeyV3ToV4 key : keys) {
            KeyType keyType;
            ApplicationUser user = this.userService.getUserById(key.getUserId().intValue());
            if (user != null) {
                keyType = (KeyType)((Object)((Function)user.accept((ApplicationUserVisitor)migratingVisitor)).apply(key));
                if (keyType == KeyType.ACCESS_KEY) {
                    updatedServiceUsers.add(user.getId());
                    ServiceUserUpdateRequest labelUpdateRequest = ((ServiceUserUpdateRequest.Builder)((ServiceUserUpdateRequest.Builder)new ServiceUserUpdateRequest.Builder((ServiceUser)user).label("access-key")).displayName(SshAccessKeyUtils.generateServiceUserDisplayName(key.getText(), key.getLabel()))).build();
                    this.userAdminService.updateServiceUser(labelUpdateRequest);
                }
            } else {
                log.info("SSH key with ID {} and label '{}' is linked to a user with ID {} but the user was not found. Setting the key type to UNKNOWN.", new Object[]{key.getId(), key.getLabel(), key.getUserId()});
                keyType = KeyType.UNKNOWN;
            }
            key.setType(keyType);
            String keyLabel = key.getLabel();
            if (keyLabel != null) {
                key.setLabelLower(keyLabel.toLowerCase(Locale.ROOT));
            }
            key.save();
        }
        log.info("Updated {} access key users (IDs: {})", (Object)updatedServiceUsers.size(), updatedServiceUsers);
        return null;
    }

    @Implementation(value=PartialSshKey.class)
    @Table(value="SSH_PUBLIC_KEY")
    public static interface AoSshKeyV3ToV4
    extends RawEntity<Integer>,
    SshKey {
        public static final String COLUMN_ID = "ENTITY_ID";
        public static final String COLUMN_USER_ID = "USER_ID";
        public static final String COLUMN_KEY_TEXT = "KEY_TEXT";
        public static final String COLUMN_KEY_TYPE = "KEY_TYPE";
        public static final String COLUMN_KEY_MD5 = "KEY_MD5";
        public static final String COLUMN_LABEL = "LABEL";
        public static final String COLUMN_LABEL_LOWER = "LABEL_LOWER";
        public static final String TABLE_NAME = "SSH_PUBLIC_KEY";
        public static final int LENGTH_MD5 = 32;
        public static final int LENGTH_LABEL = 255;

        @Override
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ENTITY_ID")
        public Integer getId();

        @Accessor(value="KEY_MD5")
        @Indexed
        @NotNull
        @StringLength(value=32)
        public String getMD5();

        @Override
        @Accessor(value="LABEL")
        @Nullable
        @StringLength(value=255)
        public String getLabel();

        @Accessor(value="LABEL_LOWER")
        @Nullable
        @StringLength(value=255)
        public String getLabelLower();

        @Mutator(value="LABEL_LOWER")
        public void setLabelLower(String var1);

        @Override
        @Accessor(value="KEY_TEXT")
        @NotNull
        @StringLength(value=-1)
        public String getText();

        @Override
        @Accessor(value="KEY_TYPE")
        public KeyType getType();

        @Mutator(value="KEY_TYPE")
        public void setType(KeyType var1);

        @Accessor(value="USER_ID")
        @Indexed
        @NotNull
        public Integer getUserId();

        @Ignore
        public void initialize(ApplicationUser var1);

        @Override
        @Ignore
        @Nullable
        public ApplicationUser getUser();

        @Override
        @Ignore
        @Nonnull
        public PublicKey toPublicKey();
    }

    private static class MigratingApplicationUserVisitor
    extends AbstractApplicationUserVisitor<Function<AoSshKeyV3ToV4, KeyType>> {
        private MigratingApplicationUserVisitor() {
        }

        public Function<AoSshKeyV3ToV4, KeyType> visit(@Nonnull ServiceUser user) {
            return key -> this.isAccessKeyUser(user, (AoSshKeyV3ToV4)key) ? KeyType.ACCESS_KEY : KeyType.SERVICE;
        }

        protected Function<AoSshKeyV3ToV4, KeyType> defaultValue(ApplicationUser user) {
            return key -> KeyType.USER_KEY;
        }

        private boolean isAccessKeyUser(ServiceUser user, AoSshKeyV3ToV4 key) {
            if ("access-key".equals(user.getLabel())) {
                return true;
            }
            String displayName = user.getDisplayName();
            return displayName.contains(".service.ssh.key.service.user.name") || displayName.startsWith("Access key user") || displayName.startsWith("Zugriffsschl\u00fcssel-Benutzer") || displayName.startsWith("Utilisateur de la cl\u00e9 d'acc\u00e8s") || displayName.startsWith("\u30a2\u30af\u30bb\u30b9\u30ad\u30fc\u30e6\u30fc\u30b6\u30fc") || displayName.contains(SshAccessKeyUtils.getKeyIdentifier(key.getText(), key.getLabel()));
        }
    }
}

