/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.dao.v5;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.key.ssh.dao.PartialSshKey;
import com.atlassian.bitbucket.internal.key.ssh.dao.v5.AoSshKeyV5;
import com.atlassian.bitbucket.ssh.KeyType;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.util.Arrays;
import net.java.ao.Accessor;
import net.java.ao.Implementation;
import net.java.ao.Mutator;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.Ignore;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrectDisabledUserKeyTypeTask
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(CorrectDisabledUserKeyTypeTask.class);
    private final int pageSize;
    private final UserService userService;

    CorrectDisabledUserKeyTypeTask(UserService userService, int pageSize) {
        this.pageSize = pageSize;
        this.userService = userService;
    }

    public CorrectDisabledUserKeyTypeTask(UserService userService) {
        this(userService, 1000);
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"5");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"4")), (Object)"This upgrade task can only upgrade from version 4 to 5");
        log.info("Migrating to correct disabled user key types.");
        ao.migrateDestructively(new Class[]{AoSshKeyV4ToV5.class});
        Query query = Query.select().order("ENTITY_ID");
        PagedIterable keys = new PagedIterable(request -> PageUtils.createPage(Arrays.asList((AoSshKeyV4ToV5[])ao.find(AoSshKeyV4ToV5.class, AoUtils.restrict((Query)query, (PageRequest)request))), (PageRequest)request), this.pageSize);
        MigratingVisitor visitor = new MigratingVisitor();
        for (AoSshKeyV4ToV5 key : keys) {
            ApplicationUser user;
            if (key.getType() != KeyType.UNKNOWN || (user = this.userService.getUserById(key.getUserId().intValue(), true)) == null) continue;
            key.setType((KeyType)((Object)user.accept((ApplicationUserVisitor)visitor)));
            key.save();
        }
        ao.migrateDestructively(new Class[]{AoSshKeyV5.class});
    }

    @Implementation(value=PartialSshKey.class)
    @Table(value="SSH_PUBLIC_KEY")
    public static interface AoSshKeyV4ToV5
    extends RawEntity<Integer>,
    SshKey {
        public static final String COLUMN_ID = "ENTITY_ID";
        public static final String COLUMN_USER_ID = "USER_ID";
        public static final String COLUMN_KEY_TEXT = "KEY_TEXT";
        public static final String COLUMN_KEY_TYPE = "KEY_TYPE";
        public static final String COLUMN_KEY_MD5 = "KEY_MD5";
        public static final String COLUMN_LABEL = "LABEL";
        public static final String COLUMN_LABEL_LOWER = "LABEL_LOWER";
        public static final String TABLE_NAME = "SSH_PUBLIC_KEY";
        public static final int LENGTH_MD5 = 32;
        public static final int LENGTH_LABEL = 255;

        @Override
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ENTITY_ID")
        public Integer getId();

        @Accessor(value="KEY_MD5")
        @Indexed
        @NotNull
        @StringLength(value=32)
        public String getMD5();

        @Override
        @Accessor(value="LABEL")
        @Nullable
        @StringLength(value=255)
        public String getLabel();

        @Accessor(value="LABEL_LOWER")
        @Nullable
        @StringLength(value=255)
        public String getLabelLower();

        @Override
        @Accessor(value="KEY_TEXT")
        @NotNull
        @StringLength(value=-1)
        public String getText();

        @Override
        @NotNull
        @Accessor(value="KEY_TYPE")
        public KeyType getType();

        @Mutator(value="KEY_TYPE")
        public void setType(KeyType var1);

        @Accessor(value="USER_ID")
        @Indexed
        @NotNull
        public Integer getUserId();

        @Ignore
        public void initialize(ApplicationUser var1);

        @Override
        @Ignore
        @Nullable
        public ApplicationUser getUser();

        @Override
        @Ignore
        @Nonnull
        public PublicKey toPublicKey();
    }

    private static class MigratingVisitor
    extends AbstractApplicationUserVisitor<KeyType> {
        private MigratingVisitor() {
        }

        public KeyType visit(@Nonnull ServiceUser user) {
            return "access-key".equals(user.getLabel()) ? KeyType.ACCESS_KEY : KeyType.SERVICE;
        }

        protected KeyType defaultValue(ApplicationUser user) {
            return KeyType.USER_KEY;
        }
    }
}

