/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.dao.v6;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.internal.key.ssh.dao.PartialSshKey;
import com.atlassian.bitbucket.internal.key.ssh.dao.v6.AoSshKeyV6;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.ssh.KeyType;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.StandardDigests;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.util.Arrays;
import net.java.ao.Accessor;
import net.java.ao.Implementation;
import net.java.ao.Mutator;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.Ignore;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.LoggerFactory;

public class UpdateEd25519KeyMd5sTask
implements ActiveObjectsUpgradeTask {
    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"6");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"5")), (Object)"This upgrade task can only upgrade from version 5 to 6");
        ao.migrateDestructively(new Class[]{AoSshKeyV5ToV6.class});
        MutableInt count = new MutableInt();
        PageUtils.toStream((PageProvider)new KeyPageProvider(ao), (int)1000).forEach(key -> {
            PublicKey publicKey = KeyUtils.getPublicKey(key.getText());
            key.setMD5(StandardDigests.MD5.apply(publicKey.getEncoded()));
            key.save();
            count.increment();
        });
        LoggerFactory.getLogger(this.getClass()).info("Re-encoded {} ED25519 keys", (Object)count.intValue());
        ao.migrateDestructively(new Class[]{AoSshKeyV6.class});
    }

    @Implementation(value=PartialSshKey.class)
    @Table(value="SSH_PUBLIC_KEY")
    public static interface AoSshKeyV5ToV6
    extends RawEntity<Integer>,
    SshKey {
        public static final String COLUMN_ID = "ENTITY_ID";
        public static final String COLUMN_LABEL = "LABEL";
        public static final String COLUMN_LABEL_LOWER = "LABEL_LOWER";
        public static final String COLUMN_KEY_MD5 = "KEY_MD5";
        public static final String COLUMN_KEY_TEXT = "KEY_TEXT";
        public static final String COLUMN_KEY_TYPE = "KEY_TYPE";
        public static final String COLUMN_USER_ID = "USER_ID";
        public static final String TABLE_NAME = "SSH_PUBLIC_KEY";
        public static final int LENGTH_MD5 = 32;
        public static final int LENGTH_LABEL = 255;

        @Override
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ENTITY_ID")
        public Integer getId();

        @Accessor(value="KEY_MD5")
        @Indexed
        @NotNull
        @StringLength(value=32)
        public String getMD5();

        @Override
        @Accessor(value="LABEL")
        @Nullable
        @StringLength(value=255)
        public String getLabel();

        @Accessor(value="LABEL_LOWER")
        @Indexed
        @Nullable
        @StringLength(value=255)
        public String getLabelLower();

        @Override
        @Accessor(value="KEY_TEXT")
        @NotNull
        @StringLength(value=-1)
        public String getText();

        @Override
        @NotNull
        @Accessor(value="KEY_TYPE")
        public KeyType getType();

        @Accessor(value="USER_ID")
        @Indexed
        @NotNull
        public Integer getUserId();

        @Ignore
        public void initialize(ApplicationUser var1);

        @Override
        @Ignore
        @Nullable
        public ApplicationUser getUser();

        @Mutator(value="KEY_MD5")
        public void setMD5(String var1);

        @Override
        @Ignore
        @Nonnull
        public PublicKey toPublicKey();
    }

    private static class KeyPageProvider
    implements PageProvider<AoSshKeyV5ToV6> {
        private final ActiveObjects ao;
        private final Query query;

        public KeyPageProvider(ActiveObjects ao) {
            this.ao = ao;
            this.query = Query.select((String)"ENTITY_ID, KEY_TEXT").order("ENTITY_ID").where("KEY_TEXT LIKE 'ssh-ed25519 %'", new Object[0]);
        }

        @Nonnull
        public Page<AoSshKeyV5ToV6> get(@Nonnull PageRequest request) {
            return PageUtils.createPage(Arrays.asList((AoSshKeyV5ToV6[])this.ao.find(AoSshKeyV5ToV6.class, AoUtils.restrict((Query)this.query, (PageRequest)request))), (PageRequest)request);
        }
    }
}

