/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.dao.v7;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.key.ssh.dao.v7.AoSshKeyV7;
import com.atlassian.bitbucket.internal.ssh.dao.AoSshKeyTypeRestriction;
import com.atlassian.bitbucket.internal.ssh.service.SshSupportedKeyTypesProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class ApplySchemaChangesV7Task
implements ActiveObjectsUpgradeTask {
    private final SshSupportedKeyTypesProvider sshSupportedKeyTypesProvider;

    protected ApplySchemaChangesV7Task(SshSupportedKeyTypesProvider sshSupportedKeyTypesProvider) {
        this.sshSupportedKeyTypesProvider = sshSupportedKeyTypesProvider;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"7");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"6")), (Object)"This upgrade task can only upgrade from version 6 to 7");
        ao.migrate(new Class[]{AoSshKeyV7.class, AoSshKeyTypeRestriction.class});
        this.addSshKeyTypeRestrictions(ao);
    }

    private void addSshKeyTypeRestrictions(ActiveObjects ao) {
        Map<String, List<Integer>> sshSupportedKeyTypes = this.sshSupportedKeyTypesProvider.getSupportedKeyLengthsByType();
        sshSupportedKeyTypes.forEach((algorithm, supportedKeyLengths) -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"ALGORITHM", algorithm);
            builder.put((Object)"MIN_KEY_LENGTH", supportedKeyLengths.get(0));
            ao.create(AoSshKeyTypeRestriction.class, (Map)builder.build());
        });
    }
}

