/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.dao.v8;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.ssh.dao.AoSshKeyTypeRestriction;
import com.atlassian.bitbucket.internal.ssh.service.SshSupportedKeyTypesProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSecurityKeyTypeRestrictionsTask
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AddSecurityKeyTypeRestrictionsTask.class);
    private final SshSupportedKeyTypesProvider keyTypesProvider;

    public AddSecurityKeyTypeRestrictionsTask(SshSupportedKeyTypesProvider keyTypesProvider) {
        this.keyTypesProvider = keyTypesProvider;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"8");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"7")), (Object)"This upgrade task can only upgrade from version 7 to 8");
        Map<String, List<Integer>> supportedKeyLengthsByType = this.keyTypesProvider.getSupportedKeyLengthsByType();
        Set existingKeyTypes = Arrays.stream((AoSshKeyTypeRestriction[])ao.find(AoSshKeyTypeRestriction.class, Query.select().from(AoSshKeyTypeRestriction.class))).map(AoSshKeyTypeRestriction::getAlgorithm).collect(Collectors.toSet());
        supportedKeyLengthsByType.entrySet().stream().filter(type -> !existingKeyTypes.contains(type.getKey())).forEach(newSupportedType -> {
            log.debug("Creating new restriction for key type: {}", newSupportedType.getKey());
            ao.create(AoSshKeyTypeRestriction.class, (Map)ImmutableMap.of((Object)"ALGORITHM", newSupportedType.getKey(), (Object)"MIN_KEY_LENGTH", Collections.min((Collection)newSupportedType.getValue())));
        });
    }
}

