/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.rest;

import com.atlassian.bitbucket.internal.ssh.rest.RestSshKey;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.function.Function;

@JsonSerialize
public class RestSshAccessKey
extends RestMapEntity {
    public static final Function<SshAccessKey, RestSshAccessKey> REST_TRANSFORM = RestSshAccessKey::new;
    private static final String KEY = "key";
    private static final String PROJECT = "project";
    private static final String REPOSITORY = "repository";
    private static final String PERMISSION = "permission";

    public RestSshAccessKey() {
    }

    public RestSshAccessKey(RestSshKey key, RestProject project, RestRepository repository, Permission permission) {
        this.put(KEY, (Object)key);
        this.putIfNotNull(PROJECT, project);
        this.putIfNotNull(REPOSITORY, repository);
        this.put(PERMISSION, permission);
    }

    public RestSshAccessKey(SshAccessKey accessKey) {
        this.put(KEY, (Object)new RestSshKey(accessKey.getKey()));
        Object resource = accessKey.getResource();
        if (resource instanceof Project) {
            this.put(PROJECT, new RestProject((Project)resource));
        } else {
            this.put(REPOSITORY, new RestRepository((Repository)resource));
        }
        this.put(PERMISSION, accessKey.getPermission().name());
    }

    public RestSshKey getKey() {
        return RestSshKey.valueOf(this.get(KEY));
    }

    public Permission getPermission() {
        if (this.containsKey(PERMISSION)) {
            return Permission.valueOf((String)this.getStringProperty(PERMISSION));
        }
        return null;
    }

    public RestProject getProject() {
        return RestProject.valueOf((Object)this.get(PROJECT));
    }

    public RestRepository getRepository() {
        return RestRepository.valueOf((Object)this.get(REPOSITORY));
    }

    public boolean hasKey() {
        return this.getKey() != null;
    }

    public boolean hasPermission() {
        return this.containsKey(PERMISSION);
    }

    public boolean hasProject() {
        return this.getProject() != null;
    }

    public boolean hasRepository() {
        return this.getRepository() != null;
    }
}

