/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@JsonSerialize
public class RestSshAccessKeyLocations
extends RestMapEntity {
    private static final String KEY_REPOSITORIES = "repositories";
    private static final String KEY_PROJECTS = "projects";

    public RestSshAccessKeyLocations() {
    }

    public RestSshAccessKeyLocations(Collection<RestRepository> repositories, Collection<RestProject> projects) {
        this.putIfNotNull(KEY_PROJECTS, projects);
        this.putIfNotNull(KEY_REPOSITORIES, repositories);
    }

    @Schema(implementation=RestProject.class)
    public Collection<RestProject> getProjects() {
        Object projects = this.get(KEY_PROJECTS);
        if (projects == null) {
            return Collections.emptySet();
        }
        return ((List)projects).stream().map(RestProject::valueOf).collect(Collectors.toList());
    }

    @Schema(implementation=RestRepository.class)
    public Collection<RestRepository> getRepositories() {
        Object repositories = this.get(KEY_REPOSITORIES);
        if (repositories == null) {
            return Collections.emptySet();
        }
        return ((List)repositories).stream().map(RestRepository::valueOf).collect(Collectors.toList());
    }
}

