/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.dmz.rest.v2.util.RestPermissionUtils;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.key.ssh.InternalSshAccessKeyService;
import com.atlassian.bitbucket.internal.key.ssh.rest.RestRestrictedSshAccessKey;
import com.atlassian.bitbucket.internal.key.ssh.rest.RestSshAccessKey;
import com.atlassian.bitbucket.internal.key.ssh.rest.RestSshAccessKeyLocations;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshKey;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.ssh.SetSshAccessKeyRequest;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshAccessKeySearchRequest;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@LicensedOnly
@BasePathDoc(value="/keys/latest")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="/")
@Tag(name="Authentication")
public class SshAccessKeyResource {
    private static final String PREFIX_SSH = "ssh";
    private static final String SUFFIX_SSH = "/ssh";
    private final I18nService i18nService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;
    private final InternalSshAccessKeyService sshAccessKeyService;
    private final Function<RestProject, Project> projectLookup = new Function<RestProject, Project>(){

        @Override
        public Project apply(RestProject restProj) {
            Project project = null;
            if (restProj.getId() > 0) {
                project = SshAccessKeyResource.this.projectService.getById(restProj.getId());
            }
            if (project == null && restProj.getKey() != null) {
                project = SshAccessKeyResource.this.projectService.getByKey(restProj.getKey());
            }
            if (project == null) {
                throw SshAccessKeyResource.this.newNoResourceFoundException();
            }
            return project;
        }
    };
    private Function<RestRepository, Repository> repositoryLookup = new Function<RestRepository, Repository>(){

        @Override
        public Repository apply(RestRepository restRepo) {
            Repository repo = null;
            if (restRepo.getId() > 0) {
                repo = SshAccessKeyResource.this.repositoryService.getById(restRepo.getId());
            }
            if (repo == null && restRepo.getSlug() != null && restRepo.getProject() != null && restRepo.getProject().getKey() != null) {
                repo = SshAccessKeyResource.this.repositoryService.getBySlug(restRepo.getProject().getKey(), restRepo.getSlug());
            }
            if (repo == null) {
                throw SshAccessKeyResource.this.newNoResourceFoundException();
            }
            return repo;
        }
    };

    @Inject
    public SshAccessKeyResource(I18nService i18nService, ProjectService projectService, RepositoryService repositoryService, InternalSshAccessKeyService sshAccessKeyService) {
        this.i18nService = i18nService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.sshAccessKeyService = sshAccessKeyService;
    }

    @Operation(description="Register a new SSH key and grants access to the project identified in the URL.", summary="Add project SSH key")
    @Parameter(description="The project key", in=ParameterIn.PATH, name="projectKey")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestSshAccessKey.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created access key.", representation=RestSshAccessKey.class, responseCode=201), @ResponseDoc(documentation="The current request contains invalid or missing values.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to add an access key to the project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @POST
    @Path(value="projects/{projectKey}/ssh")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addForProject(@BeanParam ProjectResolver projectResolver, RestSshAccessKey accessKey, @Context UriInfo uriInfo) {
        if (accessKey == null || !accessKey.hasKey()) {
            return ResponseFactory.badRequest((String)"Missing key").build();
        }
        try {
            RestSshKey key = accessKey.getKey();
            SshAccessKey result = this.sshAccessKeyService.set(new SetSshAccessKeyRequest.Builder().key(key.getText(), key.getLabel(), key.getExpiryDays()).scopeAccess((Scope)Scopes.project((Project)projectResolver.getProject()), accessKey.hasPermission() ? accessKey.getPermission() : Permission.PROJECT_READ).build());
            URI uri = uriInfo.getRequestUriBuilder().replaceQuery(null).path(Integer.toString(accessKey.getKey().getId())).build(new Object[0]);
            return ResponseFactory.created((URI)uri).entity((Object)new RestSshAccessKey(result)).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)e.getMessage()).build();
        }
    }

    @Operation(description="Register a new SSH key and grants access to the repository identified in the URL.", summary="Add repository SSH key")
    @Parameters(value={@Parameter(description="The project key", in=ParameterIn.PATH, name="projectKey"), @Parameter(description="The repository slug", in=ParameterIn.PATH, name="repositorySlug")})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestSshAccessKey.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created access key.", representation=RestSshAccessKey.class, responseCode=201), @ResponseDoc(documentation="The current request contains invalid or missing values.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to add an access key to the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist.", restError=true, responseCode=404)})
    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/ssh")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addForRepository(@BeanParam RepositoryResolver repositoryResolver, RestSshAccessKey accessKey, @Context UriInfo uriInfo) {
        if (accessKey == null || !accessKey.hasKey()) {
            return ResponseFactory.badRequest((String)"Missing key").build();
        }
        try {
            Permission permission = accessKey.getPermission();
            RestSshKey key = accessKey.getKey();
            SshAccessKey result = this.sshAccessKeyService.set(new SetSshAccessKeyRequest.Builder().key(key.getText(), key.getLabel(), key.getExpiryDays()).scopeAccess((Scope)Scopes.repository((Repository)repositoryResolver.getRepository()), permission != null ? permission : Permission.REPO_READ).build());
            URI uri = uriInfo.getRequestUriBuilder().replaceQuery(null).path(Integer.toString(accessKey.getKey().getId())).build(new Object[0]);
            return ResponseFactory.created((URI)uri).entity((Object)new RestSshAccessKey(result)).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)e.getMessage()).build();
        }
    }

    @Operation(description="Remove an existing access key for the projects and repositories in the submitted entity. If the same SSH key is used as an access key for multiple projects or repositories not supplied, only the access to the projects or repositories identified will be revoked.", summary="Revoke project SSH key")
    @Parameter(description="The identifier of the SSH key", in=ParameterIn.PATH, name="keyId")
    @ResponseDocs(value={@ResponseDoc(documentation="The access keys were deleted (or none was found matching the given id and repositories or projects).", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to remove access keys for one or more of the specified projects or repositories.", restError=true, responseCode=401), @ResponseDoc(documentation="On or more of the specified repositories or projects does not exist or the key itself does not exist.", restError=true, responseCode=404)})
    @DELETE
    @Path(value="ssh/{keyId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokeMany(@PathParam(value="keyId") Integer keyId, RestSshAccessKeyLocations locations) {
        Collection<RestProject> projects = this.ensureAllLocationsNonNull("projects", locations.getProjects());
        Collection<RestRepository> repositories = this.ensureAllLocationsNonNull("repositories", locations.getRepositories());
        this.sshAccessKeyService.revoke(keyId, repositories.stream().map(this.repositoryLookup).collect(Collectors.toSet()), projects.stream().map(this.projectLookup).collect(Collectors.toSet()));
        return Response.noContent().build();
    }

    @Operation(description="Retrieves the access keys for the project identified in the URL.", summary="Get SSH key")
    @Parameters(value={@Parameter(description="If specified only SSH access keys with a label prefixed with the supplied string will be returned.", in=ParameterIn.QUERY, name="filter"), @Parameter(description="If specified only SSH access keys with at least the supplied permission will be returned Default is PROJECT_READ.", in=ParameterIn.QUERY, name="permission"), @Parameter(description="The project key", in=ParameterIn.PATH, name="projectKey")})
    @ResponseDocs(value={@ResponseDoc(documentation="A single page of access keys associated with the project.", representation=RestSshAccessKey.class, paged=true, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the access keys for this project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="projects/{projectKey}/ssh")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSshKeysForProject(@BeanParam ProjectResolver projectResolver, @QueryParam(value="filter") String filter, @QueryParam(value="permission") String permission, @BeanParam PageRequestResolver pageRequestResolver) {
        Permission perm = Objects.requireNonNull(RestPermissionUtils.parsePermission((I18nService)this.i18nService, (String)permission, Project.class, (Permission)Permission.PROJECT_READ, (String)"permission"), "permission");
        Page<SshAccessKey> page = this.sshAccessKeyService.search(new SshAccessKeySearchRequest.Builder((Scope)Scopes.project((Project)projectResolver.getProject())).labelPrefix(filter).minimumPermission(perm).build(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestSshAccessKey.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieves the access keys for the repository identified in the URL.", summary="Get repository SSH keys")
    @Parameters(value={@Parameter(description="If specified only SSH access keys with a label prefixed with the supplied string will be returned", in=ParameterIn.QUERY, name="filter"), @Parameter(description="Controls whether SSH access keys configured at the project level should be included in the results or not. When set to <code>true</code> all keys that have <em>access</em> to the repository (including project level keys) are included in the results. When set to <code>false</code>, only access keys configured for the specified <code>repository</code> are considered. Default is <code>false</code>.", in=ParameterIn.QUERY, name="effective"), @Parameter(description="If specified only SSH access keys with at least the supplied permission will be returned. Default is <code>Permission.REPO_READ</code>.", in=ParameterIn.QUERY, name="minimumPermission"), @Parameter(description="The project key.", in=ParameterIn.PATH, name="projectKey"), @Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @ResponseDocs(value={@ResponseDoc(documentation="A single page of access keys for the repository.", representation=RestSshAccessKey.class, paged=true, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the access keys for this repository", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist", restError=true, responseCode=404)})
    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/ssh")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getForRepository(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="filter") String filter, @QueryParam(value="effective") @DefaultValue(value="false") boolean effective, @QueryParam(value="permission") String minimumPermission, @BeanParam PageRequestResolver pageRequestResolver) {
        Permission perm = RestPermissionUtils.parsePermission((I18nService)this.i18nService, (String)minimumPermission, Repository.class, (Permission)Permission.REPO_READ, (String)"permission");
        Page<SshAccessKey> page = this.sshAccessKeyService.search(new SshAccessKeySearchRequest.Builder((Scope)Scopes.repository((Repository)repositoryResolver.getRepository())).labelPrefix(filter).effective(effective).minimumPermission(perm).build(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestSshAccessKey.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieves the access key for the SSH key with id <code>keyId</code> on the project identified in the URL.", summary="Get project SSH key")
    @Parameters(value={@Parameter(description="The key id", in=ParameterIn.PATH, name="keyId"), @Parameter(description="The project key", in=ParameterIn.PATH, name="projectKey")})
    @ResponseDocs(value={@ResponseDoc(documentation="The access key for the repository and SSH key with ID <code>keyId</code>.", representation=RestSshAccessKey.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the access keys for this repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository or key does not exist or the key does not have access on the repository.", restError=true, responseCode=404)})
    @GET
    @Path(value="projects/{projectKey}/ssh/{keyId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getForProject(@BeanParam ProjectResolver projectResolver, @PathParam(value="keyId") Integer keyId) {
        return this.sshAccessKeyService.getByKeyAndProject(keyId, projectResolver.getProject()).map(accessKey -> ResponseFactory.ok((Object)((Object)new RestSshAccessKey((SshAccessKey)accessKey))).build()).orElse(this.notFound(projectResolver.getProject(), keyId));
    }

    @Operation(description="Retrieves the access key for the SSH key with id <code>keyId</code> on the repository identified in the URL.", summary="Get repository SSH key")
    @Parameters(value={@Parameter(description="The project key", in=ParameterIn.PATH, name="projectKey"), @Parameter(description="The repository slug", in=ParameterIn.PATH, name="repositorySlug"), @Parameter(description="The key id", in=ParameterIn.PATH, name="keyId")})
    @ResponseDocs(value={@ResponseDoc(documentation="The access key for the repository and SSH key with ID <code>keyId</code>.", representation=RestSshAccessKey.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the access keys for this repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository or key does not exist or the key does not have access on the repository.", restError=true, responseCode=404)})
    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/ssh/{keyId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getForRepository(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="keyId") Integer keyId) {
        return this.sshAccessKeyService.getByKeyAndRepository(keyId, repositoryResolver.getRepository()).map(accessKey -> ResponseFactory.ok((Object)((Object)new RestSshAccessKey((SshAccessKey)accessKey))).build()).orElse(this.notFound(repositoryResolver.getRepository(), keyId));
    }

    @Operation(description="Retrieves all project-related access keys for the SSH key with id <code>keyId</code>. If the current user is not an admin any of the projects the key provides access to, none are returned.", summary="Get project SSH keys")
    @ResponseDocs(value={@ResponseDoc(documentation="The SSH key with ID <code>keyId</code>.", paged=true, responseCode=200), @ResponseDoc(documentation="The specified key does not exist", restError=true, responseCode=404)})
    @GET
    @Path(value="ssh/{keyId}/projects")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getForProjects(@PathParam(value="keyId") Integer keyId, @BeanParam PageRequestResolver pageRequestResolver) {
        return ResponseFactory.ok((Object)new RestPage(this.sshAccessKeyService.findByKeyForProjects(keyId, pageRequestResolver.getPageRequest()), RestSshAccessKey.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieves all repository-related access keys for the SSH key with id <code>keyId</code>. If the current user is not an admin of any of the projects the key provides access to, none are returned.", summary="Get repository SSH key")
    @Parameters(value={@Parameter(description="The key id", in=ParameterIn.PATH, name="keyId"), @Parameter(description="Include the readOnly field. The `readOnly` field is contextual for the user making the request. `readOnly` returns true if there is a restriction and the user does not have`PROJECT_ADMIN` access for the repository the key is associated with.", in=ParameterIn.QUERY, name="withRestrictions")})
    @ResponseDocs(value={@ResponseDoc(documentation="The SSH key with ID <code>keyId</code>.", paged=true, responseCode=200), @ResponseDoc(documentation="The specified key does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="ssh/{keyId}/repos")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getForRepositories(@PathParam(value="keyId") Integer keyId, @BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="withRestrictions") @DefaultValue(value="false") boolean withRestrictions) {
        if (withRestrictions) {
            return ResponseFactory.ok((Object)new RestPage(this.sshAccessKeyService.findByKeyForRepositoriesWithRestrictions(keyId, pageRequestResolver.getPageRequest()), RestRestrictedSshAccessKey.REST_TRANSFORM)).build();
        }
        return ResponseFactory.ok((Object)new RestPage(this.sshAccessKeyService.findByKeyForRepositories(keyId, pageRequestResolver.getPageRequest()), RestSshAccessKey.REST_TRANSFORM)).build();
    }

    @Operation(description="Remove an existing access key for the project identified in the URL. If the same SSH key is used as an access key for multiple projects or repositories, only the access to the project identified in the URL will be revoked.", summary="Revoke project SSH key")
    @Parameters(value={@Parameter(description="The project key", in=ParameterIn.PATH, name="projectKey"), @Parameter(description="The key id", in=ParameterIn.PATH, name="keyId")})
    @ResponseDocs(value={@ResponseDoc(documentation="The access key was deleted (or none was found matching the given id).", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to remove access keys for this project.", restError=true, responseCode=401)})
    @DELETE
    @Path(value="projects/{projectKey}/ssh/{keyId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokeForProject(@BeanParam ProjectResolver projectResolver, @PathParam(value="keyId") Integer keyId) {
        this.sshAccessKeyService.revoke((int)keyId, projectResolver.getProject());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Remove an existing access key for the repository identified in the URL. If the same SSH key is used as an access key for multiple projects or repositories, only the access to the repository identified in the URL will be revoked.", summary="Revoke repository SSH key")
    @Parameters(value={@Parameter(description="The project key", in=ParameterIn.PATH, name="projectKey"), @Parameter(description="The repository slug", in=ParameterIn.PATH, name="repositorySlug"), @Parameter(description="The key id", in=ParameterIn.PATH, name="keyId")})
    @ResponseDocs(value={@ResponseDoc(documentation="The access key was deleted (or none was found matching the given id).", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to remove access keys for this repository", restError=true, responseCode=401)})
    @DELETE
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/ssh/{keyId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokeForRepository(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="keyId") Integer keyId) {
        this.sshAccessKeyService.revoke((int)keyId, repositoryResolver.getRepository());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Updates the permission granted to the specified SSH key to the project identified in the URL.", summary="Update project SSH key permission")
    @Parameters(value={@Parameter(description="The newly created access key", in=ParameterIn.PATH, name="keyId"), @Parameter(description="The new permission to be granted to the SSH key", in=ParameterIn.PATH, name="permission"), @Parameter(description="The project key", in=ParameterIn.PATH, name="projectKey")})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created access key.", representation=RestSshAccessKey.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions on the project to edit its access keys.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @PUT
    @Path(value="projects/{projectKey}/ssh/{keyId}/permission/{permission}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updatePermission(@BeanParam ProjectResolver projectResolver, @PathParam(value="keyId") Integer keyId, @PathParam(value="permission") Permission permission) {
        try {
            SshAccessKey accessKey = this.sshAccessKeyService.set(new SetSshAccessKeyRequest.Builder().key(keyId).scopeAccess((Scope)Scopes.project((Project)projectResolver.getProject()), permission).build());
            return ResponseFactory.ok((Object)((Object)new RestSshAccessKey(accessKey))).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)e.getMessage()).build();
        }
    }

    @Operation(description="Updates the permission granted to the specified SSH key to the repository identified in the URL.", summary="Update repository SSH key permission")
    @Parameters(value={@Parameter(description="The project key", in=ParameterIn.PATH, name="projectKey"), @Parameter(description="The repository slug", in=ParameterIn.PATH, name="repositorySlug"), @Parameter(description="The newly created access key", in=ParameterIn.PATH, name="keyId"), @Parameter(description="The new permission to be granted to the SSH key", in=ParameterIn.PATH, name="permission")})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created access key.", representation=RestSshAccessKey.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions on the repository to edit its access keys.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist.", restError=true, responseCode=404)})
    @PUT
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/ssh/{keyId}/permission/{permission}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updatePermission(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="keyId") Integer keyId, @PathParam(value="permission") Permission permission) {
        try {
            SshAccessKey accessKey = this.sshAccessKeyService.set(new SetSshAccessKeyRequest.Builder().key(keyId).scopeAccess((Scope)Scopes.repository((Repository)repositoryResolver.getRepository()), permission).build());
            return ResponseFactory.ok((Object)((Object)new RestSshAccessKey(accessKey))).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)e.getMessage()).build();
        }
    }

    private <T> Collection<T> ensureAllLocationsNonNull(String locationType, Collection<T> resources) {
        for (T resource : resources) {
            if (resource != null) continue;
            throw new BadRequestException(locationType, this.i18nService.getMessage("bitbucket.service.ssh.key.access.resource.null", new Object[]{locationType}));
        }
        return resources;
    }

    private Response notFound(String message) {
        return ResponseFactory.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RestErrorMessage(message)).type("application/json;charset=UTF-8").build();
    }

    private Response notFound(Project project, Integer keyId) {
        return this.notFound(this.i18nService.getMessage("bitbucket.ssh.project.nosuchkeyaccess", new Object[]{keyId, project.getKey()}));
    }

    private Response notFound(Repository repository, Integer keyId) {
        return this.notFound(this.i18nService.getMessage("bitbucket.ssh.repo.nosuchkeyaccess", new Object[]{keyId, repository.getProject().getKey(), repository.getSlug()}));
    }

    private NoSuchEntityException newNoResourceFoundException() {
        throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.access.resource.notfound", new Object[0]));
    }
}

