/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.verify;

import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.io.pem.PemReader;

public class DecodedSshSignature {
    private static final String GIT_NAMESPACE = "git";
    private static final String PREAMBLE = "SSHSIG";
    private static final int SUPPORTED_VERSION = 1;
    private static final ImmutableSet<String> supportedHashAlgorithms = ImmutableSet.of((Object)"sha256", (Object)"sha512");
    private final byte[] hashAlgorithm;
    private final byte[] magicPreamble;
    private final byte[] namespace;
    private final PublicKey publicKey;
    private final byte[] reserved;
    private final byte[] signature;
    private final String signatureAlgorithm;
    private int counter;
    private byte flags;

    private DecodedSshSignature(String sshSignature) throws IOException {
        byte[] signatureData = DecodedSshSignature.getSignatureBytes(sshSignature);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(signatureData));
        this.magicPreamble = new byte[6];
        in.read(this.magicPreamble);
        if (!PREAMBLE.equals(new String(this.magicPreamble, StandardCharsets.UTF_8))) {
            throw new IllegalArgumentException("Error while decoding SSH signature - invalid preamble: " + Arrays.toString(this.magicPreamble));
        }
        int version = in.readInt();
        if (version != 1) {
            throw new IllegalArgumentException("Error while decoding SSH signature - invalid version: " + version);
        }
        this.publicKey = KeyUtils.getPublicKey(DecodedSshSignature.readString(in));
        this.namespace = DecodedSshSignature.readString(in);
        if (!GIT_NAMESPACE.equals(new String(this.namespace, StandardCharsets.UTF_8))) {
            throw new IllegalArgumentException("Error while decoding SSH signature - invalid namespace: " + new String(this.namespace, StandardCharsets.UTF_8));
        }
        this.reserved = new byte[4];
        in.read(this.reserved);
        this.hashAlgorithm = DecodedSshSignature.readString(in);
        if (!supportedHashAlgorithms.contains((Object)new String(this.hashAlgorithm, StandardCharsets.UTF_8))) {
            throw new IllegalArgumentException("Error while decoding SSH signature - invalid hash algorithm: " + new String(this.hashAlgorithm, StandardCharsets.UTF_8));
        }
        in.readInt();
        this.signatureAlgorithm = new String(DecodedSshSignature.readString(in), StandardCharsets.UTF_8);
        this.signature = DecodedSshSignature.readString(in);
        if (this.publicKey instanceof SecurityKeyPublicKey) {
            this.flags = in.readByte();
            this.counter = in.readInt();
        }
    }

    public static DecodedSshSignature fromPem(@Nonnull String pemEncodedSignature) throws IOException {
        Objects.requireNonNull(pemEncodedSignature, "pemEncodedSignature");
        return new DecodedSshSignature(pemEncodedSignature);
    }

    @Nonnull
    public byte[] createSignedData(String payload) throws IOException, NoSuchAlgorithmException {
        try (ByteArrayOutputStream signedData = new ByteArrayOutputStream();){
            signedData.write(this.magicPreamble);
            DecodedSshSignature.writeStringWithLength(signedData, this.namespace);
            signedData.write(this.reserved);
            DecodedSshSignature.writeStringWithLength(signedData, this.hashAlgorithm);
            byte[] digest = MessageDigest.getInstance(new String(this.hashAlgorithm, StandardCharsets.UTF_8)).digest(payload.getBytes(StandardCharsets.UTF_8));
            DecodedSshSignature.writeStringWithLength(signedData, digest);
            byte[] byArray = signedData.toByteArray();
            return byArray;
        }
    }

    @Nonnull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Nonnull
    public byte[] getSignature() throws IOException {
        if (this.publicKey == null) {
            throw new IllegalArgumentException("Public key not initialized");
        }
        if (this.publicKey instanceof SecurityKeyPublicKey) {
            try (ByteArrayOutputStream signedData = new ByteArrayOutputStream();){
                DecodedSshSignature.writeStringWithLength(signedData, this.signatureAlgorithm.getBytes(StandardCharsets.UTF_8));
                DecodedSshSignature.writeStringWithLength(signedData, this.signature);
                signedData.write(ByteBuffer.allocate(1).put(this.flags).array());
                signedData.write(ByteBuffer.allocate(4).putInt(this.counter).array());
                byte[] byArray = signedData.toByteArray();
                return byArray;
            }
        }
        return this.signature;
    }

    @Nonnull
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    private static byte[] getSignatureBytes(String sshSignature) throws IOException {
        byte[] byArray;
        PemReader reader = new PemReader((Reader)new StringReader(sshSignature));
        try {
            byArray = reader.readPemObject().getContent();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DecoderException e) {
                throw new IOException(e);
            }
        }
        reader.close();
        return byArray;
    }

    private static byte[] readString(DataInputStream in) throws IOException {
        int stringSize = in.readInt();
        byte[] result = new byte[stringSize];
        in.read(result);
        return result;
    }

    private static void writeStringWithLength(ByteArrayOutputStream stream, byte[] value) throws IOException {
        stream.write(ByteBuffer.allocate(4).putInt(value.length).array());
        stream.write(value);
    }
}

