/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh;

import com.atlassian.bitbucket.ssh.KeyType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SshKeySearchRequest {
    private final String labelPrefix;
    private final KeyType keyType;

    private SshKeySearchRequest(@Nonnull Builder builder) {
        this.labelPrefix = builder.labelPrefix;
        this.keyType = builder.keyType;
    }

    @Nonnull
    public Optional<String> getLabelPrefix() {
        return Optional.ofNullable(this.labelPrefix);
    }

    @Nonnull
    public Optional<KeyType> getKeyType() {
        return Optional.ofNullable(this.keyType);
    }

    public static class Builder {
        private String labelPrefix;
        private KeyType keyType;

        @Nonnull
        public SshKeySearchRequest build() {
            return new SshKeySearchRequest(this);
        }

        @Nonnull
        public Builder labelPrefix(@Nullable String value) {
            this.labelPrefix = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder keyType(@Nullable KeyType value) {
            this.keyType = value;
            return this;
        }
    }
}

