/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.atst;

import com.atlassian.bitbucket.auth.SshAuthenticationFailureHandlerModuleDescriptor;
import com.atlassian.bitbucket.auth.SshAuthenticationHandlerModuleDescriptor;
import com.atlassian.bitbucket.auth.SshAuthenticationSuccessHandlerModuleDescriptor;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class SshSupportData
extends RootLevelSupportDataAppender {
    private static final String SSH = "bitbucket.atst.ssh";
    private static final String SSH_ACCESS_KEYS = "bitbucket.atst.ssh.access-keys";
    private static final String SSH_AUTHENTICATION_HANDLERS = "bitbucket.atst.ssh.authentication-handlers";
    private static final String SSH_BASE_URL = "bitbucket.atst.ssh.base-url";
    private static final String SSH_ENABLED = "bitbucket.atst.ssh.enabled";
    private static final String SSH_FAILURE_HANDLERS = "bitbucket.atst.ssh.failure-handlers";
    private static final String SSH_HANDLER = "bitbucket.atst.ssh.handler";
    private static final String SSH_HANDLER_CLASS = "bitbucket.atst.ssh.handler.class";
    private static final String SSH_HANDLER_ENABLED = "bitbucket.atst.ssh.handler.enabled";
    private static final String SSH_HANDLER_KEY = "bitbucket.atst.ssh.handler.key";
    private static final String SSH_HANDLER_PLUGIN = "bitbucket.atst.ssh.handler.plugin";
    private static final String SSH_HANDLER_WEIGHT = "bitbucket.atst.ssh.handler.weight";
    private static final String SSH_NOT_CONFIGURED = "bitbucket.atst.ssh.notconfigured";
    private static final String SSH_PORT = "bitbucket.atst.ssh.port";
    private static final String SSH_SUCCESS_HANDLERS = "bitbucket.atst.ssh.success-handlers";
    private final SshConfigurationService configurationService;
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;

    public SshSupportData(SshConfigurationService configurationService, I18nService i18nService, PluginAccessor pluginAccessor) {
        this.configurationService = configurationService;
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        SshConfiguration configuration = this.configurationService.getConfiguration();
        SupportDataBuilder ssh = supportDataBuilder.addCategory(SSH).addValue(SSH_ENABLED, String.valueOf(configuration.isEnabled())).addValue(SSH_PORT, String.valueOf(configuration.getPort())).addValue(SSH_BASE_URL, (String)StringUtils.defaultIfEmpty((CharSequence)configuration.getBaseUrl(), (CharSequence)this.i18nService.getMessage(SSH_NOT_CONFIGURED, new Object[0])));
        this.addHandlers(ssh, SSH_AUTHENTICATION_HANDLERS, SshAuthenticationHandlerModuleDescriptor.class);
        this.addHandlers(ssh, SSH_FAILURE_HANDLERS, SshAuthenticationFailureHandlerModuleDescriptor.class);
        this.addHandlers(ssh, SSH_SUCCESS_HANDLERS, SshAuthenticationSuccessHandlerModuleDescriptor.class);
        supportDataBuilder.addCategory(SSH_ACCESS_KEYS).addValue(SSH_ENABLED, String.valueOf(configuration.isAccessKeysEnabled()));
    }

    private <D extends BaseWeightedModuleDescriptor<T>, T> void addHandlers(SupportDataBuilder builder, String category, Class<D> descriptorClass) {
        Collection descriptors = this.pluginAccessor.getModuleDescriptors(descriptorClass::isInstance);
        if (descriptors.isEmpty()) {
            return;
        }
        SupportDataBuilder handlers = builder.addCategory(category);
        descriptors.stream().map(descriptorClass::cast).sorted().forEach(descriptor -> {
            SupportDataBuilder handler = handlers.addCategory(SSH_HANDLER).addValue(SSH_HANDLER_PLUGIN, descriptor.getPluginKey()).addValue(SSH_HANDLER_KEY, descriptor.getKey());
            if (descriptor.getModuleClass() != null) {
                handler.addValue(SSH_HANDLER_CLASS, descriptor.getModuleClass().getName());
            }
            handler.addValue(SSH_HANDLER_ENABLED, String.valueOf(descriptor.isEnabled())).addValue(SSH_HANDLER_WEIGHT, String.valueOf(descriptor.getWeight()));
        });
    }
}

