/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.internal.ssh.event.SshKeysGlobalExpiryChangedEvent;
import com.atlassian.bitbucket.internal.ssh.event.SshKeysTypeRestrictionMinLengthChangedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyEditedEvent;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyEvent;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyGrantedEvent;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyRevokedEvent;
import com.atlassian.bitbucket.ssh.event.SshConfigurationChangedEvent;
import com.atlassian.bitbucket.ssh.event.SshKeyCreatedEvent;
import com.atlassian.bitbucket.ssh.event.SshKeyDeletedEvent;
import com.atlassian.bitbucket.ssh.event.SshKeyEditedEvent;
import com.atlassian.bitbucket.ssh.event.SshKeyEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SshEventListener {
    @VisibleForTesting
    static final String ACTION_SSH_ACCESS_KEY_DELETED = "bitbucket.ssh.audit.action.sshaccesskeydeleted";
    @VisibleForTesting
    static final String ACTION_SSH_ACCESS_KEY_EDITED = "bitbucket.ssh.audit.action.sshaccesskeyedited";
    @VisibleForTesting
    static final String ACTION_SSH_ACCESS_KEY_GRANTED = "bitbucket.ssh.audit.action.sshaccesskeygranted";
    @VisibleForTesting
    static final String ACTION_SSH_CONFIGURATION_CHANGED = "bitbucket.ssh.audit.action.sshconfigurationchanged";
    @VisibleForTesting
    static final String ACTION_SSH_KEY_CREATED = "bitbucket.ssh.audit.action.sshkeycreated";
    @VisibleForTesting
    static final String ACTION_SSH_KEY_DELETED = "bitbucket.ssh.audit.action.sshkeydeleted";
    @VisibleForTesting
    static final String ACTION_SSH_KEY_EDITED = "bitbucket.ssh.audit.action.sshkeyedited";
    @VisibleForTesting
    static final String ACTION_SSH_KEYS_GLOBAL_EXPIRY_CHANGED = "bitbucket.ssh.audit.action.sshkeysglobalexpiry.changed";
    @VisibleForTesting
    static final String ACTION_SSH_KEYS_TYPE_RESTRICTION_MIN_LENGTH_CHANGED = "bitbucket.ssh.audit.action.sshkeystyperestrictionminlength.changed";
    @VisibleForTesting
    static final String ATTR_SSH_ACCESS_KEY_PERMISSION = "bitbucket.ssh.audit.attr.sshaccesskey.permission";
    @VisibleForTesting
    static final String ATTR_SSH_KEY_CREATED_DATE = "bitbucket.ssh.audit.attr.sshkey.createddate";
    @VisibleForTesting
    static final String ATTR_SSH_KEY_EXPIRY_DAYS = "bitbucket.ssh.audit.attr.sshkey.expirydays";
    @VisibleForTesting
    static final String ATTR_SSH_KEY_ID = "bitbucket.ssh.audit.attr.sshkey.id";
    @VisibleForTesting
    static final String ATTR_SSH_KEY_LABEL = "bitbucket.ssh.audit.attr.sshkey.label";
    @VisibleForTesting
    static final String ATTR_SSH_KEY_PUBLIC_KEY = "bitbucket.ssh.audit.attr.sshkey.publickey";
    @VisibleForTesting
    static final String KEY_ACCESS_KEY_ENABLED = "bitbucket.ssh.audit.changedvalue.sshconfigurationchanged.accesskeyenabled";
    @VisibleForTesting
    static final String KEY_BASE_URL = "bitbucket.ssh.audit.changedvalue.sshconfigurationchanged.baseurl";
    @VisibleForTesting
    static final String KEY_PORT = "bitbucket.ssh.audit.changedvalue.sshconfigurationchanged.port";
    @VisibleForTesting
    static final String KEY_SSH_ENABLED = "bitbucket.ssh.audit.changedvalue.sshconfigurationchanged.sshenabled";
    @VisibleForTesting
    static final String KEY_SSH_KEYS_GLOBAL_EXPIRY_CHANGED = "bitbucket.ssh.audit.changedvalue.sshkeysglobalexpiry.changed";
    @VisibleForTesting
    static final String KEY_SSH_KEYS_TYPE_RESTRICTION_MIN_LENGTH_CHANGED = "bitbucket.ssh.audit.changedvalue.sshkeystyperestrictionminlength.changed";
    @VisibleForTesting
    static final String KEY_SSH_KEYS_TYPE_RESTRICTION_MIN_LENGTH_ALGORITHM = "bitbucket.ssh.audit.changedvalue.sshkeystyperestrictionminlength.algorithm";
    private final AuditService auditService;

    public SshEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onSshAccessKeyEditedEvent(SshAccessKeyEditedEvent event) {
        AuditEvent.Builder accessKeyEventBuilder = SshEventListener.getSshAccessKeyEventBuilder(event, ACTION_SSH_ACCESS_KEY_EDITED);
        this.auditService.audit(accessKeyEventBuilder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_SSH_ACCESS_KEY_PERMISSION).from(event.getOldAccessKey().getPermission().name()).to(event.getAccessKey().getPermission().name()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_ID, (String)String.valueOf(event.getAccessKey().getKey().getId())).build()).build());
    }

    @EventListener
    public void onSshAccessKeyGrantedEvent(SshAccessKeyGrantedEvent event) {
        AuditEvent.Builder accessKeyEventBuilder = SshEventListener.getSshAccessKeyEventBuilder(event, ACTION_SSH_ACCESS_KEY_GRANTED);
        SshEventListener.addAllKeyValuesToBuilder(accessKeyEventBuilder, event.getAccessKey().getKey());
        this.auditService.audit(accessKeyEventBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_ACCESS_KEY_PERMISSION, (String)event.getAccessKey().getPermission().name()).build()).build());
    }

    @EventListener
    public void onSshAccessKeyRevokedEvent(SshAccessKeyRevokedEvent event) {
        AuditEvent.Builder accessKeyEventBuilder = SshEventListener.getSshAccessKeyEventBuilder(event, ACTION_SSH_ACCESS_KEY_DELETED);
        SshEventListener.addAllKeyValuesToBuilder(accessKeyEventBuilder, event.getAccessKey().getKey());
        this.auditService.audit(accessKeyEventBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_ACCESS_KEY_PERMISSION, (String)event.getAccessKey().getPermission().name()).build()).build());
    }

    @EventListener
    public void onSshConfigurationChangedEvent(SshConfigurationChangedEvent event) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.globaladministration", (String)ACTION_SSH_CONFIGURATION_CHANGED).build();
        SshConfiguration oldConfig = event.getOldConfiguration();
        SshConfiguration newConfig = event.getNewConfiguration();
        AuditEvent auditEvent = AuditEvent.builder((AuditType)type).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_SSH_ENABLED).from(Boolean.toString(oldConfig.isEnabled())).to(Boolean.toString(newConfig.isEnabled())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_ACCESS_KEY_ENABLED).from(Boolean.toString(oldConfig.isAccessKeysEnabled())).to(Boolean.toString(newConfig.isAccessKeysEnabled())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PORT).from(Integer.toString(oldConfig.getPort())).to(Integer.toString(newConfig.getPort())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_BASE_URL).from(oldConfig.getBaseUrl()).to(newConfig.getBaseUrl()).build()).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onSshKeyCreatedEvent(SshKeyCreatedEvent event) {
        AuditEvent.Builder sshKeyEventBuilder = SshEventListener.getSshKeyEventBuilder(event, ACTION_SSH_KEY_CREATED);
        this.auditService.audit(sshKeyEventBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_LABEL, (String)event.getKey().getLabel()).build()).build());
    }

    @EventListener
    public void onSshKeyDeletedEvent(SshKeyDeletedEvent event) {
        AuditEvent.Builder sshKeyEventBuilder = SshEventListener.getSshKeyEventBuilder(event, ACTION_SSH_KEY_DELETED);
        this.auditService.audit(sshKeyEventBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_LABEL, (String)event.getKey().getLabel()).build()).build());
    }

    @EventListener
    public void onSshKeyEditedEvent(SshKeyEditedEvent event) {
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.usersandgroups", (String)ACTION_SSH_KEY_EDITED).build());
        SshKey key = event.getKey();
        ApplicationUser user = key.getUser();
        if (user != null) {
            builder.affectedObject(AuditUtils.auditResourceForUser((ApplicationUser)user));
        }
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_ID, (String)String.valueOf(key.getId())).build());
        this.auditService.audit(builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_SSH_KEY_LABEL).from(event.getOldKey().getLabel()).to(event.getKey().getLabel()).build()).build());
    }

    @EventListener
    public void onSshKeysGlobalExpiryChangedEvent(SshKeysGlobalExpiryChangedEvent event) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)ACTION_SSH_KEYS_GLOBAL_EXPIRY_CHANGED).build();
        String oldExpiry = event.getPreviousExpiry() == null ? null : event.getPreviousExpiry().toString();
        String newExpiry = event.getNewExpiry() == null ? null : event.getNewExpiry().toString();
        AuditEvent auditEvent = AuditEvent.builder((AuditType)type).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_SSH_KEYS_GLOBAL_EXPIRY_CHANGED).from(oldExpiry).to(newExpiry).build()).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onSshKeysTypeRestrictionMinLengthChangedEvent(SshKeysTypeRestrictionMinLengthChangedEvent event) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)ACTION_SSH_KEYS_TYPE_RESTRICTION_MIN_LENGTH_CHANGED).build();
        Integer previousKeyLength = event.getPreviousKeyLength();
        Integer newKeyLength = event.getNewKeyLength();
        AuditEvent auditEvent = AuditEvent.builder((AuditType)type).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_SSH_KEYS_TYPE_RESTRICTION_MIN_LENGTH_CHANGED).from(String.valueOf(previousKeyLength)).to(newKeyLength == null ? "null" : newKeyLength.toString()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)KEY_SSH_KEYS_TYPE_RESTRICTION_MIN_LENGTH_ALGORITHM, (String)event.getAlgorithm()).build()).build();
        this.auditService.audit(auditEvent);
    }

    private static void addAllKeyValuesToBuilder(AuditEvent.Builder builder, SshKey key) {
        String createdDate = key.getCreatedDate() == null ? "null" : key.getCreatedDate().toString();
        String expiryDays = key.getExpiryDays() == null ? "null" : key.getExpiryDays().toString();
        String keyLabel = key.getLabel() == null ? null : key.getLabel();
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_ID, (String)String.valueOf(key.getId())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_CREATED_DATE, (String)createdDate).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_EXPIRY_DAYS, (String)expiryDays).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_LABEL, (String)keyLabel).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_PUBLIC_KEY, (String)key.getText()).build());
    }

    private static Map<String, Object> createKeyMap(SshKey key) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"id", (Object)key.getId());
        if (key.getLabel() != null) {
            builder.put((Object)"label", (Object)key.getLabel());
        }
        return builder.build();
    }

    private static Map<String, Object> createRepositoryMap(Repository repository) {
        return ImmutableMap.builder().put((Object)"id", (Object)repository.getId()).put((Object)"slug", (Object)repository.getSlug()).put((Object)"project", SshEventListener.createProjectMap(repository.getProject())).build();
    }

    private static Map<String, Object> createProjectMap(Project project) {
        return ImmutableMap.builder().put((Object)"id", (Object)project.getId()).put((Object)"key", (Object)project.getKey()).build();
    }

    private static AuditEvent.Builder getSshKeyEventBuilder(SshKeyEvent event, String actionI18nKey) {
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.usersandgroups", (String)actionI18nKey).build());
        SshKey key = event.getKey();
        ApplicationUser user = key.getUser();
        if (user != null) {
            builder.affectedObject(AuditUtils.auditResourceForUser((ApplicationUser)user));
        }
        String createdDate = key.getCreatedDate() == null ? "null" : key.getCreatedDate().toString();
        String expiryDays = key.getExpiryDays() == null ? "null" : key.getExpiryDays().toString();
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_ID, (String)String.valueOf(key.getId())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_CREATED_DATE, (String)createdDate).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_EXPIRY_DAYS, (String)expiryDays).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SSH_KEY_PUBLIC_KEY, (String)key.getText()).build());
        return builder;
    }

    private static AuditEvent.Builder getSshAccessKeyEventBuilder(SshAccessKeyEvent event, String actionI18nKeyPrefix) {
        AuditEvent.Builder builder;
        SshAccessKey accessKey = event.getAccessKey();
        SshKey key = accessKey.getKey();
        Map<String, Object> keyMap = SshEventListener.createKeyMap(key);
        ImmutableMap.Builder detailsBuilder = ImmutableMap.builder().put((Object)"key", keyMap).put((Object)"permission", (Object)accessKey.getPermission().name());
        if (accessKey.getResource() instanceof Project) {
            Project project = (Project)accessKey.getResource();
            detailsBuilder.put((Object)"project", SshEventListener.createProjectMap(project));
            builder = AuditEvent.fromI18nKeys((String)"bitbucket.service.audit.category.projects", (String)(actionI18nKeyPrefix + ".project"), (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION).affectedObject(AuditUtils.auditResourceForProject((Project)project));
        } else {
            Repository repository = (Repository)accessKey.getResource();
            detailsBuilder.put((Object)"repository", SshEventListener.createRepositoryMap(repository));
            builder = AuditEvent.fromI18nKeys((String)"bitbucket.service.audit.category.repositories", (String)(actionI18nKeyPrefix + ".repository"), (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION).appendAffectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repository));
        }
        ApplicationUser user = event.getAccessKey().getKey().getUser();
        if (user != null) {
            builder.affectedObject(AuditUtils.auditResourceForUser((ApplicationUser)user));
        }
        return builder;
    }
}

