/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.condition;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class UserHasSshKeyCondition
implements Condition {
    private final SshKeyService sshKeyService;
    private final AuthenticationContext authenticationContext;
    private boolean negate;

    public UserHasSshKeyCondition(SshKeyService sshKeyService, AuthenticationContext authenticationContext) {
        this.sshKeyService = sshKeyService;
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.negate = Boolean.valueOf(params.get("negate"));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        return this.negate != this.sshKeyService.hasSshKey(currentUser);
    }
}

