/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.dao;

import com.atlassian.bitbucket.internal.ssh.dao.SshConfigurationDao;
import com.atlassian.bitbucket.ssh.SimpleSshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SshConfigurationDaoImpl
implements SshConfigurationDao {
    private static final String SSH_SETTINGS_MAP = "stash.ssh.settings";
    private static final String PROP_ACCESS_KEYS_ENABLED = "access.keys.enabled";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_PORT = "port";
    private static final String PROP_BASE_URL = "base.url";
    private final PluginSettings pluginSettings;

    public SshConfigurationDaoImpl(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @Override
    public void setConfiguration(@Nonnull SshConfiguration sshConfiguration) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(PROP_ACCESS_KEYS_ENABLED, String.valueOf(sshConfiguration.isAccessKeysEnabled()));
        settings.put(PROP_ENABLED, String.valueOf(sshConfiguration.isEnabled()));
        settings.put(PROP_PORT, String.valueOf(sshConfiguration.getPort()));
        if (!StringUtils.isEmpty((CharSequence)sshConfiguration.getBaseUrl())) {
            settings.put(PROP_BASE_URL, org.springframework.util.StringUtils.trimTrailingCharacter((String)sshConfiguration.getBaseUrl(), (char)'/'));
        }
        this.pluginSettings.put(SSH_SETTINGS_MAP, settings);
    }

    @Override
    @Nonnull
    public Optional<SshConfiguration> getConfiguration() {
        return Optional.ofNullable((Map)this.pluginSettings.get(SSH_SETTINGS_MAP)).map(settings -> {
            String accessKeysEnabled = StringUtils.defaultString((String)((String)settings.get(PROP_ACCESS_KEYS_ENABLED)), (String)"true");
            return new SimpleSshConfiguration(Boolean.parseBoolean((String)settings.get(PROP_ENABLED)), Boolean.parseBoolean(accessKeysEnabled), Integer.parseInt((String)settings.get(PROP_PORT)), (String)settings.get(PROP_BASE_URL));
        });
    }
}

