/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.email;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.ssh.event.SshKeyEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.function.Function;

public class SshKeyMailBuilder
implements Function<MailMessage.Builder, MailMessage.Builder> {
    @VisibleForTesting
    static final String IN_REPLY_TO_HEADER = "in-reply-to";
    @VisibleForTesting
    static final String MESSAGE_ID_HEADER = "message-id";
    @VisibleForTesting
    static final String REFERENCES_HEADER = "references";
    private static final String ID_FORMAT = "%s-%s";
    private static final String MESSAGE_ID_FORMAT = "<%s-%3$d@%2$s>";
    private static final String REPLY_TO_FORMAT = "<%s@%s>";
    private final String messageId;
    private final String replyTo;

    public SshKeyMailBuilder(SshKeyEvent event, String type) {
        String formattedId = String.format(ID_FORMAT, type, event.getKey().getId());
        this.messageId = String.format(MESSAGE_ID_FORMAT, formattedId, Product.NAME, System.nanoTime());
        this.replyTo = String.format(REPLY_TO_FORMAT, formattedId, Product.NAME);
    }

    @Override
    public MailMessage.Builder apply(MailMessage.Builder builder) {
        return builder.header(MESSAGE_ID_HEADER, this.messageId).header(IN_REPLY_TO_HEADER, this.replyTo).header(REFERENCES_HEADER, this.replyTo);
    }
}

