/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.email;

import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.internal.ssh.email.SshKeyMailBuilder;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.ssh.event.SshKeyCreatedEvent;
import com.atlassian.bitbucket.ssh.event.SshKeyDeletedEvent;
import com.atlassian.bitbucket.ssh.event.SshKeyEvent;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.springframework.stereotype.Component;

@Component
public class SshKeyMailer {
    @VisibleForTesting
    static final String CONTEXT_KEY_KEY_LABEL = "keyLabel";
    private static final String CONTEXT_KEY_KEY_MANAGE_URL = "manageUrl";
    private static final String CONTEXT_KEY_KEY_MODULE = "moduleKey";
    private static final String CONTEXT_KEY_KEY_TEXT = "keyText";
    private static final String CONTEXT_KEY_KEY_USER = "user";
    private static final String NOTIFICATION_EMAIL_STYLES_MODULE = "com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles";
    private static final String SOY_EMAIL_TEMPLATE_MODULE = "com.atlassian.stash.ssh-plugin:ssh-key-email-templates";
    private static final String SOY_TEMPLATE_BASE = "bitbucket.internal.notification.email.ssh.key";
    private static final String SSH_KEY_EMAIL_STYLES_MODULE = "com.atlassian.stash.ssh-plugin:ssh-key-email-styles";
    private final MailService mailService;
    private final NavBuilder navBuilder;
    private final ApplicationPropertiesService propertiesService;
    private final SoyMailBuilder soyMailBuilder;

    public SshKeyMailer(@Nonnull MailService mailService, @Nonnull NavBuilder navBuilder, @Nonnull ApplicationPropertiesService propertiesService, @Nonnull SoyMailBuilder soyMailBuilder) {
        this.mailService = mailService;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
        this.soyMailBuilder = soyMailBuilder;
    }

    @EventListener
    public void onSshKeyCreated(SshKeyCreatedEvent event) {
        if (this.mailService.isHostConfigured() && event.getKey().getUser() != null) {
            ImmutableMap<String, Object> context = this.getContext(event);
            this.renderAndSend((Map<String, Object>)context, event, "bitbucket.internal.notification.email.ssh.key.added", new I18nKey("bitbucket.email.ssh.key.added.subject", new Object[]{this.propertiesService.getDisplayName()}), "created");
        }
    }

    @EventListener
    public void onSshKeyDeleted(SshKeyDeletedEvent event) {
        if (this.mailService.isHostConfigured() && event.getKey().getUser() != null) {
            ImmutableMap<String, Object> context = this.getContext(event);
            this.renderAndSend((Map<String, Object>)context, event, "bitbucket.internal.notification.email.ssh.key.deleted", new I18nKey("bitbucket.email.ssh.key.deleted.subject", new Object[]{this.propertiesService.getDisplayName()}), "deleted");
        }
    }

    private ImmutableMap<String, Object> getContext(SshKeyEvent event) {
        String label = event.getKey().getLabel();
        return ImmutableMap.builder().put((Object)CONTEXT_KEY_KEY_USER, (Object)event.getKey().getUser()).put((Object)CONTEXT_KEY_KEY_MODULE, (Object)NOTIFICATION_EMAIL_STYLES_MODULE).put((Object)CONTEXT_KEY_KEY_LABEL, (Object)(label == null ? "" : label)).put((Object)CONTEXT_KEY_KEY_TEXT, (Object)event.getKey().getText()).put((Object)CONTEXT_KEY_KEY_MANAGE_URL, (Object)(this.navBuilder.buildAbsolute() + "/plugins/servlet/ssh/account/keys")).build();
    }

    private void renderAndSend(Map<String, Object> context, SshKeyEvent event, String templateName, I18nKey subjectKey, String type) {
        Iterable messages = this.soyMailBuilder.build(new SoyMailMessageRequest.Builder().cssModuleKey(SSH_KEY_EMAIL_STYLES_MODULE).context(context).messageEffector((Function)new SshKeyMailBuilder(event, type)).recipients(Collections.singleton(event.getKey().getUser())).soyTemplateModuleKey(SOY_EMAIL_TEMPLATE_MODULE).soyTemplateName(templateName).subjectKey(subjectKey).build());
        messages.forEach(arg_0 -> ((MailService)this.mailService).submit(arg_0));
    }
}

