/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.event;

import com.atlassian.bitbucket.dmz.ssh.SshAuthenticationSuccessEvent;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SshAuthenticationTracker
implements LifecycleAware {
    private static final JobId JOB_ID = JobId.of((String)SshAuthenticationTrackerJobRunner.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)SshAuthenticationTrackerJobRunner.class.getName());
    private static final Logger log = LoggerFactory.getLogger(SshAuthenticationTracker.class);
    private final ApplicationMode applicationMode;
    private final Map<String, AuthRecord> lastAuthTimes;
    private final Duration persistenceInterval;
    private final SchedulerService schedulerService;
    private final SshKeyService sshKeyService;

    public SshAuthenticationTracker(ApplicationPropertiesService applicationPropertiesService, SchedulerService schedulerService, SshKeyService sshKeyService) {
        this.schedulerService = schedulerService;
        this.sshKeyService = sshKeyService;
        this.applicationMode = applicationPropertiesService.getMode();
        this.lastAuthTimes = new ConcurrentHashMap<String, AuthRecord>();
        this.persistenceInterval = Duration.ofSeconds(applicationPropertiesService.getPluginProperty("plugin.ssh.last.authenticated.interval", 60));
    }

    @EventListener
    public void onSshAuthenticationSuccessEvent(SshAuthenticationSuccessEvent event) {
        if (this.applicationMode == ApplicationMode.MIRROR) {
            return;
        }
        this.lastAuthTimes.put(KeyUtils.calculateFingerprint(event.getPublicKey()), new AuthRecord(event.getDate(), event.getPublicKey()));
    }

    public void onStart() {
        if (this.applicationMode == ApplicationMode.MIRROR) {
            return;
        }
        SshAuthenticationTrackerJobRunner jobRunner = new SshAuthenticationTrackerJobRunner();
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)jobRunner);
        try {
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)this.persistenceInterval.toMillis(), (Date)Date.from(ZonedDateTime.now().plus(this.persistenceInterval).toInstant()))));
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule " + String.valueOf(JOB_RUNNER_KEY), (Throwable)e);
        }
    }

    public void onStop() {
        if (this.applicationMode == ApplicationMode.MIRROR) {
            return;
        }
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        this.persistLastAuthDates();
    }

    @VisibleForTesting
    public void persistLastAuthDates() {
        this.lastAuthTimes.keySet().forEach(key -> {
            try {
                AuthRecord authRecord = this.lastAuthTimes.remove(key);
                this.sshKeyService.setLastAuthenticated(authRecord.getDate(), authRecord.getPublicKey());
            }
            catch (ArgumentValidationException e) {
                log.trace("Failed to update last authentication date for key: " + key, (Throwable)e);
            }
            catch (RuntimeException e) {
                log.warn("Failed to update last authentication date for key: " + key, (Throwable)e);
            }
        });
    }

    private static class AuthRecord {
        private final Date date;
        private final PublicKey publicKey;

        AuthRecord(@Nonnull Date date, @Nonnull PublicKey publicKey) {
            this.date = date;
            this.publicKey = publicKey;
        }

        public Date getDate() {
            return this.date;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }
    }

    private class SshAuthenticationTrackerJobRunner
    implements JobRunner {
        private SshAuthenticationTrackerJobRunner() {
        }

        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            SshAuthenticationTracker.this.persistLastAuthDates();
            return JobRunnerResponse.success();
        }
    }
}

