/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.fragments;

import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.internal.key.ssh.rest.RestSshAccessKey;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshKey;
import com.atlassian.bitbucket.internal.ssh.server.HostKeyPairProvider;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestriction;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshAccessKeySearchRequest;
import com.atlassian.bitbucket.ssh.SshAccessKeyService;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.ssh.StandardDigests;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public class SshKeysContextProvider
implements ContextProvider {
    private static final PageRequest DEFAULT_PAGE_REQUEST = PageUtils.newRequest((int)0, (int)50);
    private final SshConfigurationService sshConfigurationService;
    private final SshAccessKeyService keyAccessService;
    private final SshKeyService keyService;
    private final HostKeyPairProvider keyPairProvider;
    private final UserService userService;
    private final NavBuilder navBuilder;
    private final ProjectSettingsRestrictionService projectSettingsRestrictionService;
    private final PermissionService permissionService;

    public SshKeysContextProvider(SshConfigurationService sshConfigurationService, SshAccessKeyService keyAccessService, SshKeyService keyService, HostKeyPairProvider keyPairProvider, UserService userService, NavBuilder navBuilder, ProjectSettingsRestrictionService projectSettingsRestrictionService, PermissionService permissionService) {
        this.sshConfigurationService = sshConfigurationService;
        this.keyAccessService = keyAccessService;
        this.keyService = keyService;
        this.keyPairProvider = keyPairProvider;
        this.userService = userService;
        this.navBuilder = navBuilder;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.permissionService = permissionService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ApplicationUser user = SshKeysContextProvider.convertToApplicationUser((Person)context.get("user"), this.userService);
        String addKeyUrl = this.baseUrl().path(new String[]{"ssh", "admin", "users", user.getSlug(), "keys", "add"}).buildRelative();
        String editKeyUrl = this.baseUrl().path(new String[]{"ssh", "admin", "users", user.getSlug(), "keys", "edit"}).buildRelative();
        return this.createKeyTableContext(context, user, addKeyUrl, editKeyUrl);
    }

    public Map<String, Object> createKeyTableContext(Map<String, Object> context, ApplicationUser user) {
        String addKeyUrl = this.baseUrl().path(new String[]{"ssh", "account", "keys", "add"}).buildRelative();
        String editKeyUrl = this.baseUrl().path(new String[]{"ssh", "account", "keys", "edit"}).buildRelative();
        return this.createKeyTableContext(context, user, addKeyUrl, editKeyUrl);
    }

    public Map<String, Object> createKeyTableContext(Map<String, Object> context, Repository repository) {
        SshAccessKeySearchRequest searchRequest = new SshAccessKeySearchRequest.Builder((Scope)Scopes.repository((Repository)repository)).effective(false).minimumPermission(Permission.REPO_READ).build();
        Page<SshAccessKey> keyAccesses = this.keyAccessService.search(searchRequest, DEFAULT_PAGE_REQUEST);
        Project project = repository.getProject();
        String addKeyUrl = this.baseUrl().path(new String[]{"ssh", "projects", project.getKey(), "repos", repository.getSlug(), "keys", "add"}).buildRelative();
        Optional restriction = this.projectSettingsRestrictionService.get(project, ProjectSettingsRestrictionKeys.ACCESS_KEYS);
        boolean readOnly = restriction.isPresent() && !this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN);
        String editKeyUrl = this.baseUrl().path(new String[]{"ssh", "projects", repository.getProject().getKey(), "repos", repository.getSlug(), "keys", "edit"}).buildRelative();
        return this.createResourceKeysContext(context, "repository", repository, keyAccesses, addKeyUrl, editKeyUrl, restriction.orElse(null), readOnly);
    }

    public Map<String, Object> createKeyTableContext(Map<String, Object> context, Project project) {
        SshAccessKeySearchRequest searchRequest = new SshAccessKeySearchRequest.Builder((Scope)Scopes.project((Project)project)).effective(false).minimumPermission(Permission.PROJECT_READ).build();
        Page<SshAccessKey> keyAccesses = this.keyAccessService.search(searchRequest, DEFAULT_PAGE_REQUEST);
        String addKeyUrl = this.baseUrl().path(new String[]{"ssh", "projects", project.getKey(), "keys", "add"}).buildRelative();
        String editKeyUrl = this.baseUrl().path(new String[]{"ssh", "projects", project.getKey(), "keys", "edit"}).buildRelative();
        Optional restriction = this.projectSettingsRestrictionService.get(project, ProjectSettingsRestrictionKeys.ACCESS_KEYS);
        return this.createResourceKeysContext(context, "project", project, keyAccesses, addKeyUrl, editKeyUrl, restriction.orElse(null), false);
    }

    private Map<String, Object> createResourceKeysContext(Map<String, Object> context, String resourceName, Object resource, Page<SshAccessKey> keyAccesses, String addKeyUrl, String editKeyUrl, ProjectSettingsRestriction restriction, Boolean readOnly) {
        SshConfiguration config = this.sshConfigurationService.getConfiguration();
        boolean addEnabled = config.isEnabled() && config.isAccessKeysEnabled();
        return this.createSshAccessKeysContext(keyAccesses, context, addEnabled, addKeyUrl, editKeyUrl, resourceName, resource, restriction, readOnly);
    }

    private Map<String, Object> createKeyTableContext(Map<String, Object> context, ApplicationUser user, String addKeyUrl, String editKeyUrl) {
        Page<SshKey> keys = this.keyService.findAllForUser(user, null);
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"keyPage", (Object)new RestPage(keys, RestSshKey.REST_TRANSFORM));
        return this.createKeysContext((ImmutableMap.Builder<String, Object>)builder, keys, context, true, addKeyUrl, editKeyUrl, "user", user);
    }

    private static String makeSshFormat(String fingerprint) {
        return Joiner.on((char)':').join(Splitter.fixedLength((int)2).split((CharSequence)fingerprint));
    }

    private NavBuilder.PathBuilder<NavBuilder.PluginServlets> baseUrl() {
        return this.navBuilder.pluginServlets();
    }

    private Map<String, Object> createSshAccessKeysContext(Page<SshAccessKey> keys, Map<String, Object> additionalContext, boolean addEnabled, String addKeyUrl, String editKeyUrl, String resourceContextKey, Object resource, ProjectSettingsRestriction restriction, Boolean readOnly) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"keyPage", (Object)new RestPage(keys, RestSshAccessKey.REST_TRANSFORM));
        if (restriction != null) {
            builder.put((Object)"restriction", (Object)restriction);
        }
        builder.put((Object)"readOnly", (Object)readOnly);
        return this.createKeysContext((ImmutableMap.Builder<String, Object>)builder, keys, additionalContext, addEnabled, addKeyUrl, editKeyUrl, resourceContextKey, resource);
    }

    private <K> Map<String, Object> createKeysContext(ImmutableMap.Builder<String, Object> builder, Page<K> keys, Map<String, Object> additionalContext, boolean addEnabled, String addKeyUrl, String editKeyUrl, String resourceContextKey, Object resource) {
        builder.putAll(additionalContext).put((Object)"addKeyUrl", (Object)addKeyUrl).put((Object)"editKeyUrl", (Object)editKeyUrl).put((Object)"addEnabled", (Object)addEnabled);
        if (!additionalContext.containsKey(resourceContextKey)) {
            builder.put((Object)resourceContextKey, resource);
        } else if (additionalContext.get(resourceContextKey) != resource) {
            throw new IllegalArgumentException("Context already contains key '" + resourceContextKey + "' with a different value");
        }
        if (keys.getSize() > 0) {
            ImmutableList.Builder lb = ImmutableList.builder();
            String md5Fingerprint = SshKeysContextProvider.makeSshFormat(this.keyPairProvider.getFingerprint(StandardDigests.MD5));
            lb.add((Object)String.format("MD5:%s", md5Fingerprint));
            String sha256Fingerprint = this.keyPairProvider.getFingerprint(StandardDigests.SHA256);
            lb.add((Object)String.format("SHA256:%s", sha256Fingerprint));
            builder.put((Object)"algorithm", (Object)this.keyPairProvider.getAlgorithm());
            builder.put((Object)"fingerprints", (Object)lb.build());
        }
        return builder.build();
    }

    private static ApplicationUser convertToApplicationUser(Person user, UserService userService) {
        return user instanceof ApplicationUser ? (ApplicationUser)user : userService.getUserByName(user.getName());
    }
}

