/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.json;

import com.atlassian.bitbucket.internal.key.ssh.rest.RestSshAccessKey;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshKey;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.enrich.LinkEnricher;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshKey;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;

public class SshJsonRenderer
implements JsonRenderer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final AvatarEnricher avatarEnricher;
    private final LinkEnricher linkEnricher;
    private final RequestManager requestManager;

    public SshJsonRenderer(AvatarEnricher avatarEnricher, LinkEnricher linkEnricher, RequestManager requestManager) {
        this.avatarEnricher = avatarEnricher;
        this.linkEnricher = linkEnricher;
        this.requestManager = requestManager;
    }

    public String render(@Nullable Object object, @Nonnull Map<String, Object> options) {
        RestMapEntity restSurrogate = null;
        if (object instanceof SshKey) {
            restSurrogate = new RestSshKey((SshKey)object);
        } else if (object instanceof SshAccessKey) {
            restSurrogate = new RestSshAccessKey((SshAccessKey)object);
        }
        if (restSurrogate != null) {
            this.avatarEnricher.enrich((Object)restSurrogate, AvatarRequestHelper.makeAvatarRequest((RequestManager)this.requestManager, options));
            this.linkEnricher.enrich((Object)restSurrogate);
            try {
                return OBJECT_MAPPER.writeValueAsString((Object)restSurrogate);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

