/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.bitbucket.internal.key.ssh.SSHKeyWarning;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.StandardDigests;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Positive;
import java.security.PublicKey;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize
public class RestSshKey
extends RestMapEntity {
    public static final Function<SshKey, RestSshKey> REST_TRANSFORM = RestSshKey::new;
    private static final String ALGORITHM_TYPE = "algorithmType";
    private static final String BIT_LENGTH = "bitLength";
    private static final String CREATED_DATE = "createdDate";
    private static final String EXPIRY_DAYS = "expiryDays";
    private static final String FINGERPRINT = "fingerprint";
    private static final String ID = "id";
    private static final String LABEL = "label";
    private static final String LAST_AUTHENTICATED = "lastAuthenticated";
    private static final String TEXT = "text";
    private static final String WARNING = "warning";
    private static final Logger log = LoggerFactory.getLogger(RestSshKey.class);

    public RestSshKey() {
    }

    public RestSshKey(SshKey sshKey) {
        this.putIfNotNull(ID, sshKey.getId());
        this.putIfNotNull(TEXT, sshKey.getText());
        this.putIfNotNull(LABEL, sshKey.getLabel());
        this.putIfNotNull(LAST_AUTHENTICATED, sshKey.getLastAuthenticated());
        this.putIfNotNull(CREATED_DATE, sshKey.getCreatedDate());
        this.putIfNotNull(EXPIRY_DAYS, sshKey.getExpiryDays());
        if (sshKey.isUndecodable()) {
            this.put(WARNING, (Object)SSHKeyWarning.SSH_KEY_DECODE_FAILED);
        } else {
            PublicKey publicKey = sshKey.toPublicKey();
            this.putIfNotNull(FINGERPRINT, KeyUtils.calculateFingerprint(publicKey, StandardDigests.SHA256));
            this.putIfNotNull(ALGORITHM_TYPE, KeyUtils.getKeyAlgorithm(publicKey));
            this.putIfNotNull(BIT_LENGTH, KeyUtils.calculateKeyLength(publicKey));
            this.putIfNotNull(WARNING, (Object)(sshKey.isRsaUnsafe() ? SSHKeyWarning.RSA_UNSAFE_MODULUS : null));
        }
    }

    private RestSshKey(Map<String, Object> map) {
        super(map);
    }

    public String getAlgorithmType() {
        return this.getStringProperty(ALGORITHM_TYPE);
    }

    public Integer getBitLength() {
        return this.getIntProperty(BIT_LENGTH);
    }

    @Schema(example="1630041546433", accessMode=Schema.AccessMode.READ_ONLY)
    public Date getCreatedDate() {
        return (Date)this.get(CREATED_DATE);
    }

    @Positive(message="{bitbucket.ssh.access.keys.error.expiry}")
    @Schema(example="30")
    public @Positive(message="{bitbucket.ssh.access.keys.error.expiry}") Integer getExpiryDays() {
        try {
            String expiryDays = this.getStringProperty(EXPIRY_DAYS);
            if (StringUtils.isBlank((CharSequence)expiryDays)) {
                return null;
            }
            return Integer.parseInt(expiryDays);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Schema(example="Cbg38r+gDCiNHqBk6Y1BKO+EvufFBqhFWIEXh8oq9MI", accessMode=Schema.AccessMode.READ_ONLY)
    public String getFingerprint() {
        return this.getStringProperty(FINGERPRINT);
    }

    @Schema(example="1", accessMode=Schema.AccessMode.READ_ONLY)
    public Integer getId() {
        return this.getIntProperty(ID);
    }

    @Schema(example="me@127.0.0.1")
    public String getLabel() {
        return this.getStringProperty(LABEL);
    }

    @Schema(example="1630041546434", accessMode=Schema.AccessMode.READ_ONLY)
    public String getLastAuthenticated() {
        return this.getStringProperty(LAST_AUTHENTICATED);
    }

    @Schema(example="ssh-rsa AAAAB3... me@127.0.0.1")
    public String getText() {
        return this.getStringProperty(TEXT);
    }

    @Schema(description="Contains a warning about the key, for example that it's deprecated", example="RSA_UNSAFE_MODULUS", accessMode=Schema.AccessMode.READ_ONLY)
    public String getWarning() {
        return this.getStringProperty(WARNING);
    }

    @Nullable
    public static RestSshKey valueOf(@Nullable Object value) {
        if (value instanceof RestSshKey) {
            return (RestSshKey)((Object)value);
        }
        if (value instanceof Map) {
            return new RestSshKey((Map)value);
        }
        return null;
    }
}

