/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.ssh.SshKeyFingerprint;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;

@JsonSerialize
public class RestSshKeyFingerprint
extends RestMapEntity {
    private static final String ALGORITHM = "algorithm";
    private static final String VALUE = "value";

    public RestSshKeyFingerprint(@Nonnull SshKeyFingerprint fingerprint) {
        Objects.requireNonNull(fingerprint, "fingerprint");
        this.put(ALGORITHM, fingerprint.getAlgorithm());
        this.put(VALUE, fingerprint.getValue());
    }

    public RestSshKeyFingerprint(@Nonnull Map fingerprint) {
        Objects.requireNonNull(fingerprint, "fingerprint");
        this.put(ALGORITHM, Objects.requireNonNull(fingerprint.get(ALGORITHM)));
        this.put(VALUE, Objects.requireNonNull(fingerprint.get(VALUE)));
    }

    public static RestSshKeyFingerprint valueOf(Object value) {
        if (value instanceof RestSshKeyFingerprint) {
            return (RestSshKeyFingerprint)((Object)value);
        }
        if (value instanceof Map) {
            return new RestSshKeyFingerprint((Map)value);
        }
        return null;
    }

    @Nonnull
    @Schema(example="RSA")
    public String getAlgorithm() {
        return this.getStringProperty(ALGORITHM);
    }

    @Nonnull
    @Schema(example="1BE9A09D47279BF92501DEB9A3D8717D")
    public String getValue() {
        return this.getStringProperty(VALUE);
    }
}

