/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.bitbucket.internal.ssh.rest.RestSshKeyTypeRestriction;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.ssh.SshKeyTypeRestriction;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.Positive;
import java.util.Date;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;

public class RestSshKeySettings
extends RestMapEntity {
    private static final String FALLBACK_CREATED_DATE = "fallbackCreatedDate";
    private static final String KEY_TYPE_RESTRICTIONS = "keyTypeRestrictions";
    private static final String MAX_EXPIRY_DAYS = "maxExpiryDays";

    public RestSshKeySettings() {
    }

    public RestSshKeySettings(Date fallbackCreatedDate, @Nonnull List<SshKeyTypeRestriction> keyTypeRestrictions, Integer maxExpiryDays) {
        if (maxExpiryDays != null) {
            this.put(MAX_EXPIRY_DAYS, maxExpiryDays);
        }
        if (fallbackCreatedDate != null) {
            this.put(FALLBACK_CREATED_DATE, fallbackCreatedDate);
        }
        this.put(KEY_TYPE_RESTRICTIONS, keyTypeRestrictions.stream().map(RestSshKeyTypeRestriction::new).collect(Collectors.toList()));
    }

    @ArraySchema(schema=@Schema(implementation=RestSshKeyTypeRestriction.class))
    @Nonnull
    public List<RestSshKeyTypeRestriction> getKeyTypeRestrictions() {
        return ((List)this.get(KEY_TYPE_RESTRICTIONS)).stream().map(RestSshKeyTypeRestriction::valueOf).collect(Collectors.toList());
    }

    @Nonnull
    @Schema(implementation=Integer.class)
    @Positive(message="{bitbucket.rest.ssh.keys.error.admin.expiry}")
    public @Positive(message="{bitbucket.rest.ssh.keys.error.admin.expiry}") OptionalInt getMaxExpiryDays() {
        return this.getOptionalIntProperty(MAX_EXPIRY_DAYS);
    }
}

