/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.ssh.SshKeyType;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonSerialize
public class RestSshKeyType
extends RestMapEntity {
    private static final String ALGORITHM = "algorithm";
    private static final String MIN_KEY_LENGTHS = "minKeyLengths";

    public RestSshKeyType() {
    }

    public RestSshKeyType(@Nonnull SshKeyType sshKeyType) {
        Objects.requireNonNull(sshKeyType, "sshKeyType");
        this.put(ALGORITHM, Objects.requireNonNull(sshKeyType.getAlgorithm()));
        this.put(MIN_KEY_LENGTHS, Objects.requireNonNull(sshKeyType.getMinKeyLengths()));
    }

    public RestSshKeyType(@Nonnull Map<String, Object> sshKeyType) {
        Objects.requireNonNull(sshKeyType, "sshKeyType");
        this.put(ALGORITHM, Objects.requireNonNull(sshKeyType.get(ALGORITHM)));
        this.put(MIN_KEY_LENGTHS, Objects.requireNonNull(sshKeyType.get(MIN_KEY_LENGTHS)));
    }

    @Nonnull
    @Schema(example="ECDSA")
    public String getAlgorithm() {
        return this.getStringProperty(ALGORITHM);
    }

    @Nonnull
    @ArraySchema(arraySchema=@Schema(example="[\"256\", \"384\", \"521\"]"))
    public List<Integer> getMinKeyLengths() {
        return (List)this.get(MIN_KEY_LENGTHS);
    }
}

