/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.ssh.SshKeyTypeRestriction;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;

@JsonSerialize
public class RestSshKeyTypeRestriction
extends RestMapEntity {
    private static final String ALGORITHM = "algorithm";
    private static final String ALLOWED = "allowed";
    private static final String MIN_KEY_LENGTH = "minKeyLength";

    public RestSshKeyTypeRestriction() {
    }

    public RestSshKeyTypeRestriction(@Nonnull SshKeyTypeRestriction sshKeyTypeRestriction) {
        Objects.requireNonNull(sshKeyTypeRestriction, "sshKeyTypeRestriction");
        this.put(ALGORITHM, Objects.requireNonNull(sshKeyTypeRestriction.getAlgorithm()));
        this.put(ALLOWED, sshKeyTypeRestriction.getMinKeyLength() != null);
        this.putIfNotNull(MIN_KEY_LENGTH, sshKeyTypeRestriction.getMinKeyLength());
    }

    public RestSshKeyTypeRestriction(@Nonnull Map<String, Object> sshKeyTypeRestriction) {
        Objects.requireNonNull(sshKeyTypeRestriction, "sshKeyTypeRestriction");
        this.put(ALGORITHM, Objects.requireNonNull(sshKeyTypeRestriction.get(ALGORITHM)));
        this.putIfNotNull(MIN_KEY_LENGTH, sshKeyTypeRestriction.get(MIN_KEY_LENGTH));
        this.put(ALLOWED, Objects.requireNonNull(sshKeyTypeRestriction.get(ALLOWED)));
    }

    @Nonnull
    @Schema(example="RSA")
    public String getAlgorithm() {
        return this.getStringProperty(ALGORITHM);
    }

    @Nonnull
    @Schema(implementation=Integer.class, example="2048")
    public OptionalInt getMinKeyLength() {
        return this.getOptionalIntProperty(MIN_KEY_LENGTH);
    }

    @Schema(example="true")
    public boolean isAllowed() {
        return this.getBoolProperty(ALLOWED);
    }

    @Nullable
    public static RestSshKeyTypeRestriction valueOf(@Nullable Object value) {
        if (value instanceof RestSshKeyTypeRestriction) {
            return (RestSshKeyTypeRestriction)((Object)value);
        }
        if (value instanceof SshKeyTypeRestriction) {
            return new RestSshKeyTypeRestriction((SshKeyTypeRestriction)value);
        }
        if (value instanceof Map) {
            return new RestSshKeyTypeRestriction((Map)value);
        }
        return null;
    }
}

