/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.bitbucket.internal.ssh.rest.RestSshKeyFingerprint;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.ssh.SimpleSshKeyFingerprint;
import com.atlassian.bitbucket.ssh.SshKeyFingerprint;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonSerialize
public class RestSshSettings
extends RestMapEntity {
    private static final String ACCESS_KEYS = "accessKeys";
    private static final String BASE_URL = "baseUrl";
    private static final String ENABLED = "enabled";
    private static final String FINGERPRINT = "fingerprint";
    private static final String PORT = "port";

    public RestSshSettings() {
    }

    public RestSshSettings(boolean accessKeysEnabled, @Nullable String baseUrl, boolean enabled, @Nonnull SshKeyFingerprint fingerprint, int port) {
        this.put(ACCESS_KEYS, ImmutableMap.of((Object)ENABLED, (Object)accessKeysEnabled));
        this.put(BASE_URL, Objects.requireNonNull(baseUrl, BASE_URL));
        this.put(ENABLED, enabled);
        this.put(FINGERPRINT, (Object)new RestSshKeyFingerprint(Objects.requireNonNull(fingerprint, FINGERPRINT)));
        this.put(PORT, port);
    }

    @Nonnull
    @Schema(example="ssh://example.com")
    public String getBaseUrl() {
        return this.getStringProperty(BASE_URL);
    }

    @Nonnull
    @Schema(implementation=SimpleSshKeyFingerprint.class)
    public SshKeyFingerprint getFingerprint() {
        RestSshKeyFingerprint fingerprint = RestSshKeyFingerprint.valueOf(this.get(FINGERPRINT));
        if (fingerprint == null) {
            return null;
        }
        return new SimpleSshKeyFingerprint(fingerprint.getAlgorithm(), fingerprint.getValue());
    }

    @Schema(example="7999")
    public int getPort() {
        return this.getIntProperty(PORT);
    }

    public boolean isAccessKeysEnabled() {
        return Optional.ofNullable(this.get(ACCESS_KEYS)).flatMap(accessKeys -> Optional.ofNullable((Boolean)((Map)accessKeys).get(ENABLED))).orElse(false);
    }

    @Schema(example="true")
    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED);
    }
}

