/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshKeySettings;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshKeyType;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshKeyTypeRestriction;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.ssh.SimpleSshKeyTypeRestriction;
import com.atlassian.bitbucket.ssh.SshKeySettingsService;
import com.atlassian.bitbucket.ssh.SshKeyTypeRestriction;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="admin")
@Tag(name="System Maintenance")
public class SshKeySettingsResource {
    private static final Logger log = LoggerFactory.getLogger(SshKeySettingsResource.class);
    private final I18nService i18nService;
    private final SshKeySettingsService settingsService;

    @Inject
    public SshKeySettingsResource(SshKeySettingsService settingsService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.settingsService = settingsService;
    }

    @Operation(description="Gets the global settings that enforce the maximum expiry of SSH keys and restrictions on SSH key types.", summary="Get global SSH key settings")
    @ResponseDocs(value={@ResponseDoc(documentation="The global ssh key settings configuration.", representation=RestSshKeySettings.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the ssh keys global settings configuration.", responseCode=401, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getGlobalSettings() {
        return ResponseFactory.ok().entity((Object)new RestSshKeySettings(this.settingsService.getFallbackCreatedDate(), this.settingsService.getKeyTypeRestrictions(), this.settingsService.getMaxExpiry())).build();
    }

    @Operation(description="Retrieves a list of all supported SSH key algorithms and lengths.", summary="Get supported SSH key algorithms and lengths")
    @ResponseDocs(value={@ResponseDoc(documentation="A list of supported SSH key algorithms and lengths.", responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve this list.", responseCode=401, restError=true)})
    @GET
    @Path(value="supported-key-types")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSupportedKeyTypes() {
        return ResponseFactory.ok().entity(this.settingsService.getSupportedKeyTypes().stream().map(RestSshKeyType::new).collect(MoreCollectors.toImmutableList())).build();
    }

    @Operation(description="Updates the global settings that enforces the maximum expiry of SSH keys and restrictions on SSH key types.", summary="Update global SSH key settings")
    @RequestBody(description="A request containing expiry length to be set for SSH keys and a list of SSH key type restrictions.", content={@Content(schema=@Schema(implementation=RestSshKeySettings.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The ssh key global settings were updated.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update these settings.", responseCode=401, restError=true), @ResponseDoc(documentation="The request was invalid, which may be due to:\n\n\n- attempted to set expiry to less than 1 day\n- attempted to set expiry using partial days\n- attempted to set a restriction on a key type which was invalid\n\n\nThe exact reason for the error will be provided in the error message.", responseCode=400, restError=true)})
    @PUT
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateGlobalSettings(RestSshKeySettings sshKeySettings) {
        try {
            if (sshKeySettings.getMaxExpiryDays().isPresent()) {
                this.settingsService.upsertMaxExpiry(sshKeySettings.getMaxExpiryDays().getAsInt());
            } else if (this.settingsService.getMaxExpiry() != null) {
                this.settingsService.removeMaxExpiry();
            }
            List<RestSshKeyTypeRestriction> keyTypeRestrictions = sshKeySettings.getKeyTypeRestrictions();
            if (!keyTypeRestrictions.isEmpty()) {
                this.settingsService.updateKeyTypeRestrictions(this.mapSshKeyTypeRestrictions(keyTypeRestrictions));
            }
        }
        catch (ArgumentValidationException e) {
            log.error("Exception while updating ssh key global settings", (Throwable)e);
            return ResponseFactory.badRequest((String)e.getMessage()).build();
        }
        return ResponseFactory.ok((Object)((Object)sshKeySettings)).build();
    }

    private List<SshKeyTypeRestriction> mapSshKeyTypeRestrictions(List<RestSshKeyTypeRestriction> sshKeyTypeRestrictions) {
        return sshKeyTypeRestrictions.stream().map(restriction -> {
            this.validateRestSshKeyTypeRestriction((RestSshKeyTypeRestriction)((Object)restriction));
            return new SimpleSshKeyTypeRestriction(restriction.getAlgorithm(), restriction.isAllowed() && restriction.getMinKeyLength().isPresent() ? Integer.valueOf(restriction.getMinKeyLength().getAsInt()) : null);
        }).collect(Collectors.toList());
    }

    private void validateRestSshKeyTypeRestriction(RestSshKeyTypeRestriction restriction) {
        if (restriction.getAlgorithm().isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.ssh.keys.error.admin.keyalgorithm.empty", new Object[0]));
        }
        if (restriction.isAllowed() && !restriction.getMinKeyLength().isPresent()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.ssh.keys.error.admin.keylength", new Object[]{"null", restriction.getAlgorithm()}));
        }
        if (!restriction.isAllowed() && restriction.getMinKeyLength().isPresent()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.ssh.keys.error.admin.keylength.disabled", new Object[]{restriction.getAlgorithm()}));
        }
    }
}

