/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.InternalSshKeyService;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshKey;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Objects;

@LicensedOnly
@BasePathDoc(value="/ssh/latest")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="keys")
@Tag(name="Authentication")
public class SshKeysResource {
    private final AuthenticationContext authContext;
    private final UserService userService;
    private final InternalSshKeyService sshKeyService;
    private final I18nService i18nService;

    @Inject
    public SshKeysResource(AuthenticationContext authContext, UserService userService, InternalSshKeyService sshKeyService, I18nService i18nService) {
        this.authContext = authContext;
        this.userService = userService;
        this.sshKeyService = sshKeyService;
        this.i18nService = i18nService;
    }

    @Operation(description="Retrieve a page of SSH keys.", summary="Get SSH keys for user")
    @Parameters(value={@Parameter(description="the username of the user to retrieve the keys for. If no username is specified, the SSH keys will be retrieved for the current authenticated user.", in=ParameterIn.QUERY, name="userName")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of SSH keys.", representation=RestSshKey.class, paged=true, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissionsto retrieve the SSH keys. This is only possible when a<strong>user</strong> is explicitly supplied.", restError=true, responseCode=401), @ResponseDoc(documentation="No user matches the supplied <strong>user</strong>", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSshKeys(@QueryParam(value="user") String userName, @BeanParam PageRequestResolver pageRequestResolver) {
        Page<SshKey> keys = this.sshKeyService.findAllForUser(this.getUser(userName), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(keys, RestSshKey.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve an SSH key by keyId\n\nThe authenticated user must have <strong>ADMIN</strong> permission or higher to call this resource.", summary="Get SSH key for user by keyId")
    @Parameters(value={@Parameter(description="the ID of the key to retrieve.", in=ParameterIn.PATH, name="keyId")})
    @ResponseDocs(value={@ResponseDoc(documentation="An SSH key.", representation=RestSshKey.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissionsto retrieve the SSH key. This is only possible when a<strong>keyId</strong> is explicitly supplied.", restError=true, responseCode=401), @ResponseDoc(documentation="No SSH key matches the supplied <strong>keyId</strong>", restError=true, responseCode=404)})
    @GET
    @Path(value="/{keyId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSshKey(@PathParam(value="keyId") Integer keyId) {
        SshKey key = this.sshKeyService.getById(keyId);
        if (key == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RestErrorMessage(this.i18nService.getMessage("bitbucket.service.ssh.nosuchkey", new Object[0]))).type("application/json;charset=UTF-8").build();
        }
        return ResponseFactory.ok((Object)((Object)new RestSshKey(key))).build();
    }

    @Operation(description="Add a new SSH key to a supplied user.", summary="Add SSH key for user")
    @Parameters(value={@Parameter(description="the username of the user to add the SSH key for. If no username is specified, the SSH key will be added for the current authenticated user.", in=ParameterIn.QUERY, name="user", content={@Content(schema=@Schema(implementation=RestSshKey.class))})})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created SSH key.", representation=RestSshKey.class, responseCode=201), @ResponseDoc(documentation="The SSH key was not created because the key was not a valid RSA/DSA/ECDSA/Ed25519 key of a supported length.", restError=true, responseCode=400), @ResponseDoc(documentation="Either there is no authenticated user or the currently authenticated user has insufficient permissions to add an SSH key. The latter is only possible when a <strong>user</strong> is explicitly supplied.", restError=true, responseCode=401), @ResponseDoc(documentation="No user matches the supplied <strong>user</strong>", restError=true, responseCode=404), @ResponseDoc(documentation="The SSH key already exists on the system.", restError=true, responseCode=409)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addSshKey(@QueryParam(value="user") String userName, @Context UriInfo uriInfo, RestSshKey key) {
        ApplicationUser requestUser = this.authContext.getCurrentUser();
        ApplicationUser sshKeyUser = this.getUser(userName);
        SshKey sshKey = requestUser != null && requestUser.getType() == UserType.SERVICE && Objects.equals(requestUser, sshKeyUser) ? this.sshKeyService.addForServiceUser((ServiceUser)sshKeyUser, key.getText(), key.getLabel(), key.getExpiryDays()) : this.sshKeyService.addForUser(sshKeyUser, key.getText(), key.getLabel(), key.getExpiryDays());
        URI uri = uriInfo.getRequestUriBuilder().replaceQuery(null).path(Integer.toString(sshKey.getId())).build(new Object[0]);
        return ResponseFactory.created((URI)uri).entity((Object)new RestSshKey(sshKey)).build();
    }

    @Operation(description="Delete an SSH key.\n\nThe authenticated user must have <strong>ADMIN</strong> permission or higher to call this resource.", summary="Remove SSH key")
    @Parameters(value={@Parameter(description="the id of the key to delete.", in=ParameterIn.PATH, name="keyId")})
    @ResponseDocs(value={@ResponseDoc(documentation="The SSH key matching the supplied <strong>id</strong> was deleted or did not exist.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the SSH key.", restError=true, responseCode=401)})
    @DELETE
    @Path(value="/{keyId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteSshKey(@PathParam(value="keyId") Integer keyId) {
        this.sshKeyService.remove(keyId);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Delete all SSH keys for a supplied user.", summary="Delete all user SSH key")
    @Parameters(value={@Parameter(description="the username of the user to delete the keys for. If no username is specified, the SSH keys will be deleted for the current authenticated user.", in=ParameterIn.QUERY, name="userName")})
    @ResponseDocs(value={@ResponseDoc(documentation="The SSH keys matching the supplied <strong>user</strong> were deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the SSH keys. This is only possible when a <strong>user</strong> is explicitly supplied.", restError=true, responseCode=401), @ResponseDoc(documentation="No user matches the supplied <strong>user</strong>", restError=true, responseCode=404)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteSshKeys(@QueryParam(value="user") String userName) {
        this.sshKeyService.removeAllForUser(this.getUser(userName));
        return ResponseFactory.noContent().build();
    }

    @Nonnull
    private ApplicationUser getUser(@Nullable String username) {
        ApplicationUser user = this.authContext.getCurrentUser();
        if (username != null && (user = this.userService.getUserByName(username)) == null) {
            user = this.userService.getServiceUserByName(username);
        }
        if (user == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.rest.ssh.user.notfound", new Object[0]), username);
        }
        return user;
    }
}

