/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshSettings;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.SshKeyFingerprint;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@BasePathDoc(value="/ssh/latest")
@Path(value="settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Authentication")
public class SshSettingsRestResource {
    private final PermissionValidationService permissionValidationService;
    private final SshConfigurationService sshConfigurationService;

    @Inject
    public SshSettingsRestResource(PermissionValidationService permissionValidationService, SshConfigurationService sshConfigurationService) {
        this.permissionValidationService = permissionValidationService;
        this.sshConfigurationService = sshConfigurationService;
    }

    @Operation(description="Gets the SSH settings from the upstream.", summary="Get SSH settings")
    @ResponseDocs(value={@ResponseDoc(documentation="The ssh settings from upstream", representation=RestSshSettings.class, responseCode=200), @ResponseDoc(documentation="The request was not authenticated", restError=true, responseCode=401)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response sshSettings() {
        this.permissionValidationService.validateAuthenticated();
        SshConfiguration configuration = this.sshConfigurationService.getConfiguration();
        SshKeyFingerprint fingerprint = this.sshConfigurationService.getServerFingerprint();
        String baseUrl = this.sshConfigurationService.getBaseUrl();
        return ResponseFactory.ok().entity((Object)new RestSshSettings(configuration.isAccessKeysEnabled(), baseUrl, configuration.isEnabled(), fingerprint, configuration.getPort())).build();
    }
}

