/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.scm;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.ResourceBusyException;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.server.DefaultingExitCodeCallback;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.repository.RepositoryReadOnlyException;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.ScmRequestCheckService;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScmRequestSshCommand
implements SshCommand {
    private static final Logger log = LoggerFactory.getLogger(ScmRequestSshCommand.class);
    private final SshScmRequest scmRequest;
    private final DefaultingExitCodeCallback exitCodeCallback;
    private final HelpPathService helpPathService;
    private final I18nService i18nService;
    private final ScmRequestCheckService scmRequestCheckService;

    ScmRequestSshCommand(SshScmRequest scmRequest, DefaultingExitCodeCallback exitCodeCallback, HelpPathService helpPathService, I18nService i18nService, ScmRequestCheckService scmRequestCheckService) {
        this.exitCodeCallback = exitCodeCallback;
        this.helpPathService = helpPathService;
        this.i18nService = i18nService;
        this.scmRequest = scmRequest;
        this.scmRequestCheckService = scmRequestCheckService;
    }

    public void cancel() {
        this.scmRequest.cancel();
    }

    public int run() throws IOException {
        if (this.scmRequestCheckService.checkActionAllowed((ScmRequest)this.scmRequest)) {
            log.trace("{}: Request has passed checking and will be processed", (Object)this.scmRequest);
            try {
                this.scmRequest.handleRequest();
            }
            catch (ResourceBusyException e) {
                try {
                    this.scmRequest.sendError(this.i18nService.getMessage("bitbucket.scm.throttled", new Object[0]), this.i18nService.getMessage("bitbucket.scm.throttled.detail", new Object[]{Product.NAME}));
                }
                catch (IOException e1) {
                    log.info("Could not send error message to client: '{}'", (Object)e1.getMessage());
                }
                log.info(String.format("A %s request was denied due to heavy server load. Please see %s for performance guidelines.", e.getResourceName(), this.helpPathService.getPageUrl("bitbucket.help.scaling")));
                return 1;
            }
            catch (RepositoryOfflineException e) {
                try {
                    String detailedMessage = e.getDetailedMessage() == null ? this.i18nService.getMessage("bitbucket.scm.repository.offline.detail", new Object[0]) : e.getDetailedMessage().getLocalisedMessage();
                    this.scmRequest.sendError(e.getLocalizedMessage(), detailedMessage);
                }
                catch (IOException e1) {
                    log.info("Could not send error message to client: '{}'", (Object)e1.getMessage());
                }
                return 1;
            }
            catch (RepositoryReadOnlyException e) {
                this.sendError("bitbucket.scm.repository.readonly", "bitbucket.scm.repository.readonly.detail");
                return 1;
            }
        }
        log.debug("{}: Request has failed a check and will not be processed", (Object)this.scmRequest);
        return this.exitCodeCallback.getExitCode();
    }

    private void sendError(String summaryKey, String detailKey) {
        try {
            this.scmRequest.sendError(this.i18nService.getMessage(summaryKey, new Object[0]), this.i18nService.getMessage(detailKey, new Object[0]));
        }
        catch (IOException e) {
            log.info("Could not send error message to client: '{}'", (Object)e.getMessage());
        }
    }
}

