/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.scm;

import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.scm.ScmRequestSshCommand;
import com.atlassian.bitbucket.internal.ssh.server.DefaultingExitCodeCallback;
import com.atlassian.bitbucket.scm.ScmRequestCheckService;
import com.atlassian.bitbucket.scm.ssh.ExitCodeCallback;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestContext;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestHandler;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestHandlerModuleDescriptor;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import com.atlassian.bitbucket.ssh.command.SshCommandContext;
import com.atlassian.bitbucket.ssh.command.SshCommandFactory;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.PluginAccessor;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class ScmRequestSshCommandFactory
implements SshCommandFactory {
    private final HelpPathService helpPathService;
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;
    private final ScmRequestCheckService scmRequestCheckService;

    public ScmRequestSshCommandFactory(HelpPathService helpPathService, I18nService i18nService, PluginAccessor pluginAccessor, ScmRequestCheckService scmRequestCheckService) {
        this.helpPathService = helpPathService;
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
        this.scmRequestCheckService = scmRequestCheckService;
    }

    @Nonnull
    public Optional<SshCommand> create(@Nonnull SshCommandContext context) {
        return this.getHandler(context.getCommand()).flatMap(handler -> {
            DefaultingExitCodeCallback exitCodeCallback = new DefaultingExitCodeCallback();
            return handler.create(new SshScmRequestContext.Builder(context, (ExitCodeCallback)exitCodeCallback).build()).map(request -> new ScmRequestSshCommand((SshScmRequest)request, exitCodeCallback, this.helpPathService, this.i18nService, this.scmRequestCheckService));
        });
    }

    public boolean supports(@Nonnull String command) {
        return this.getHandler(command).isPresent();
    }

    private Optional<SshScmRequestHandler> getHandler(String command) {
        return this.getHandlers().filter(handler -> handler.supports(command)).findFirst();
    }

    private Stream<SshScmRequestHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(SshScmRequestHandlerModuleDescriptor.class));
    }
}

