/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.scm.protocol;

import com.atlassian.bitbucket.internal.ssh.service.SshBaseUrlResolver;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.ScmUrlFormatter;
import com.atlassian.bitbucket.scm.protocol.AbstractPluginScmProtocol;
import com.atlassian.bitbucket.scm.ssh.SshScmProtocol;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestHandlerModuleDescriptor;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.RequestLocalMap;
import com.atlassian.plugin.PluginAccessor;
import jakarta.annotation.Nonnull;

public class PluginSshScmProtocol
extends AbstractPluginScmProtocol<SshScmRequestHandlerModuleDescriptor>
implements SshScmProtocol {
    private static final String CACHE_KEY_PREFIX = PluginSshScmProtocol.class.getName();
    private final RequestLocalMap<String, String> cloneUrlCache;
    private final SshConfigurationService configService;
    private final SshBaseUrlResolver sshBaseUrlResolver;

    public PluginSshScmProtocol(PluginAccessor pluginAccessor, ScmUrlFormatter urlFormatter, SshConfigurationService configService, RequestManager requestManager, SshBaseUrlResolver sshBaseUrlResolver) {
        super(pluginAccessor, urlFormatter);
        this.configService = configService;
        this.sshBaseUrlResolver = sshBaseUrlResolver;
        this.cloneUrlCache = new RequestLocalMap(requestManager);
    }

    @Nonnull
    public String getBaseUrl() {
        return this.sshBaseUrlResolver.getBaseUrl();
    }

    public String getCloneUrl(@Nonnull Repository repository, ApplicationUser user) {
        return (String)this.cloneUrlCache.get((Object)(CACHE_KEY_PREFIX + "-" + repository.getId()), () -> this.configService.getConfiguration().isEnabled() ? PluginSshScmProtocol.super.getCloneUrl(repository, user) : null);
    }

    @Nonnull
    public String getName() {
        return "ssh";
    }
}

