/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class ChunkedOutputStream
extends ProxyOutputStream {
    public ChunkedOutputStream(OutputStream proxy) {
        super(proxy);
    }

    public void write(byte[] bts) throws IOException {
        this.write(bts, 0, bts.length);
    }

    public void write(byte[] bts, int st, int len) throws IOException {
        int length;
        int start = st;
        for (int remaining = len; remaining > 0; remaining -= length) {
            length = Math.min(remaining, 8197);
            super.write(bts, start, length);
            start += length;
        }
    }
}

