/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.internal.ssh.server.ThrottlingPacketWriter;
import java.util.concurrent.Semaphore;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriter;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolver;
import org.apache.sshd.common.channel.throttle.DefaultChannelStreamWriter;

public class DefaultChannelStreamWriterResolver
implements ChannelStreamWriterResolver {
    private final int maxPendingWrites;

    public DefaultChannelStreamWriterResolver(int maxPendingWrites) {
        this.maxPendingWrites = maxPendingWrites;
    }

    @Override
    public ChannelStreamWriter resolveChannelStreamWriter(Channel channel, byte cmd) {
        if (this.shouldThrottle(channel)) {
            return new ThrottlingPacketWriter(channel, new Semaphore(this.maxPendingWrites));
        }
        if (channel.getChannelStreamWriterResolver() == this || channel.getChannelStreamWriterResolver() == null) {
            return new DefaultChannelStreamWriter(channel);
        }
        return channel.resolveChannelStreamWriter(channel, cmd);
    }

    private boolean shouldThrottle(Channel channel) {
        return this.maxPendingWrites > 0 && channel.getRemoteWindow().getMaxSize() > (long)this.maxPendingWrites * 8197L;
    }
}

