/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.internal.ssh.server.HostKeyPairProvider;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.ssh.Digest;
import com.atlassian.bitbucket.ssh.StandardDigests;
import com.atlassian.bitbucket.util.FilePermission;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.SetFilePermissionRequest;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.Lazy;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class DefaultHostKeyPairProvider
extends AbstractGeneratorHostKeyProvider
implements HostKeyPairProvider,
LifecycleAware {
    private static final String KEY_PAIR_FILE = "ssh-server-keys.pem";
    private final LoadingCache<Digest, String> fingerprints = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Digest, String>(){
        private final Supplier<PublicKey> publicKey = Lazy.supplier(() -> ((KeyPair)Iterables.get((Iterable)DefaultHostKeyPairProvider.this.loadKeys(null), (int)0)).getPublic());

        @Nonnull
        public String load(@Nonnull Digest digest) {
            return KeyUtils.calculateFingerprint(this.publicKey.get(), digest);
        }
    });

    public DefaultHostKeyPairProvider(StorageService storageService) {
        this.setPath(storageService.getConfigDir().resolve(KEY_PAIR_FILE));
    }

    @Override
    @Nonnull
    public String getFingerprint() {
        return this.getFingerprint(StandardDigests.MD5);
    }

    @Override
    @Nonnull
    public String getFingerprint(@Nonnull Digest digest) {
        Objects.requireNonNull(digest, "digest");
        return (String)this.fingerprints.getUnchecked((Object)digest);
    }

    public void onStart() {
    }

    public void onStop() {
    }

    @Override
    protected void doWriteKeyPair(NamedResource namedResource, KeyPair keyPair, OutputStream outputStream) throws IOException {
        this.doWriteKeyPair(keyPair, outputStream);
    }

    protected void doWriteKeyPair(KeyPair keyPair, OutputStream outputStream) throws IOException {
        JcaPEMWriter writer = new JcaPEMWriter((Writer)new OutputStreamWriter(outputStream));
        writer.writeObject((Object)keyPair);
        writer.flush();
    }

    @Override
    protected void writeKeyPair(KeyPair kp, Path keyPath) throws IOException, GeneralSecurityException {
        super.writeKeyPair(kp, keyPath);
        if (Files.exists(keyPath, new LinkOption[0])) {
            try {
                MoreFiles.setPermissions((SetFilePermissionRequest)new SetFilePermissionRequest.Builder(keyPath).ownerPermissions((Iterable)ImmutableSet.of((Object)FilePermission.READ, (Object)FilePermission.WRITE)).groupPermissions((Iterable)ImmutableSet.of((Object)FilePermission.READ)).build());
            }
            catch (IOException e) {
                this.log.warn("Could not restrict file permissions on key " + String.valueOf(keyPath.toAbsolutePath()), (Throwable)e);
            }
        }
    }
}

