/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.internal.ssh.server.NamedFactoryFilter;
import com.atlassian.bitbucket.internal.ssh.server.NamedFactoryType;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultNamedFactoryFilter
implements NamedFactoryFilter {
    private static final Logger log = LoggerFactory.getLogger(DefaultNamedFactoryFilter.class);
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public DefaultNamedFactoryFilter(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    @Override
    public <T extends NamedResource> List<T> filter(@Nonnull List<T> defaultFactories, @Nonnull NamedFactoryType namedFactoryType) {
        Objects.requireNonNull(defaultFactories, "defaultFactories");
        Objects.requireNonNull(namedFactoryType, "namedFactoryType");
        String factoriesToDisableProp = this.propertiesService.getPluginProperty(namedFactoryType.getDisabledFactoriesProperty(), "");
        Iterable factoriesToDisable = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)factoriesToDisableProp);
        List factories = defaultFactories.stream().filter(factory -> !Iterables.contains((Iterable)factoriesToDisable, (Object)factory.getName())).collect(Collectors.toList());
        log.debug("Available SSH {}: {}", (Object)namedFactoryType.name(), factories.stream().map(NamedResource::getName).collect(Collectors.toList()));
        return factories;
    }
}

