/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.SshAuthenticationContext;
import com.atlassian.bitbucket.auth.SshAuthenticationExpiredKeyException;
import com.atlassian.bitbucket.auth.SshAuthenticationHandler;
import com.atlassian.bitbucket.auth.SshAuthenticationInsecureKeyException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.server.SshKeyDetails;
import com.atlassian.bitbucket.internal.ssh.utils.KeyUtils;
import com.atlassian.bitbucket.ssh.KeyType;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.ssh.SshKeySettingsService;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.ServiceUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSshAuthenticationHandler
implements SshAuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultSshAuthenticationHandler.class);
    private final I18nService i18nService;
    private final SshKeyService sshKeyService;
    private final SshKeySettingsService sshKeySettingsService;
    private final SshConfigurationService sshConfigurationService;

    public DefaultSshAuthenticationHandler(I18nService i18nService, SshKeyService sshKeyService, SshConfigurationService sshConfigurationService, SshKeySettingsService sshKeySettingsService) {
        this.i18nService = i18nService;
        this.sshKeyService = sshKeyService;
        this.sshConfigurationService = sshConfigurationService;
        this.sshKeySettingsService = sshKeySettingsService;
    }

    @Nullable
    public AuthenticationResult performAuthentication(@Nonnull SshAuthenticationContext authenticationContext) {
        SshKey sshKey = this.sshKeyService.getByPublicKey(authenticationContext.getPublicKey());
        if (sshKey == null) {
            return null;
        }
        ApplicationUser user = this.authenticate(sshKey);
        if (user == null) {
            return null;
        }
        if (sshKey.getType() == KeyType.USER_KEY || sshKey.getType() == KeyType.ACCESS_KEY) {
            if (!this.sshKeySettingsService.meetsMinimumRestrictions(authenticationContext.getPublicKey())) {
                log.debug("Default SSH Authentication public key {} for {} does not meet requirements", (Object)KeyUtils.calculateFingerprint(authenticationContext.getPublicKey()), (Object)sshKey.getUser().getName());
                throw new SshAuthenticationInsecureKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.auth.sshkey.requirementsNotMet", new Object[]{sshKey.getUser()}));
            }
            if (this.sshKeySettingsService.hasExpired(sshKey)) {
                log.debug("Default SSH Authentication public key {} is expired for {}", (Object)KeyUtils.calculateFingerprint(authenticationContext.getPublicKey()), (Object)sshKey.getUser().getName());
                throw new SshAuthenticationExpiredKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.auth.sshkey.expired", new Object[0]));
            }
        }
        return new AuthenticationResult.Builder(user).build();
    }

    private ApplicationUser authenticate(@Nonnull SshKey sshKey) {
        ApplicationUser user = sshKey.getUser();
        if (user == null || this.sshConfigurationService.getConfiguration().isAccessKeysEnabled()) {
            return user;
        }
        if ((user = (ApplicationUser)user.accept((ApplicationUserVisitor)new AbstractApplicationUserVisitor<ApplicationUser>(this){

            public ApplicationUser visit(@Nonnull ApplicationUser user) {
                return user;
            }

            public ApplicationUser visit(@Nonnull DetailedUser user) {
                return user;
            }

            public ApplicationUser visit(@Nonnull ServiceUser user) {
                return "access-key".equals(user.getLabel()) ? null : user;
            }
        })) != null) {
            new SshKeyDetails(Integer.toString(sshKey.getId()), sshKey.getLabel()).putInMDC();
        }
        return user;
    }
}

